% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamix.R
\name{datamix}
\alias{datamix}
\title{datamix}
\format{A data frame with 100 observations on the following 8 variables.
\describe{
 \item{y}{Direct estimator for each domain.}
 \item{x.hat1}{Auxiliary variable (measured with error) for each domain.}
 \item{x.hat2}{Auxiliary variable (measured with error) for each domain.}
 \item{x3}{Auxiliary Variable (measured without error) for each domain.}
 \item{x4}{Auxiliary Variable (measured without error) for each domain.}
 \item{vardir}{Sampling variances for each domain.}
 \item{var.x1}{MSE of auxiliary variable and sorted as \code{x.hat1}}
 \item{var.x2}{MSE of auxiliary variable and sorted as \code{x.hat2}}
}}
\usage{
data(datamix)
}
\description{
This data generated by simulation based on Fay-Herriot with Measurement Error Model by following these steps:
\enumerate{
  \item Generate \eqn{x_{1i}}{x1i} from a UNIF(5, 10) distribution, \eqn{x_{2i}}{x2i} from a UNIF(9, 11) distribution, \eqn{\psi_{i}}{\psii} = 3, \eqn{c_{1i}}{c1i} = \eqn{c_{2i}}{c2i} = 0.25, and \eqn{\sigma_{v}^{2}}{\sigma2v} = 2.
  \item Generate \eqn{u_{1i}}{u1i} from a N(0, \eqn{c_{1i}}{c1i}) distribution, \eqn{u_{2i}}{u2i} from a N(0, \eqn{c_{2i}}{c2i}) distribution, \eqn{e_{i}}{ei} from a N(0, \eqn{\psi_{i}}{\psii}) distribution, and \eqn{v_{i}}{vi} from a N(0, \eqn{\sigma_{v}^{2}}{\sigma2v}) distribution.
  \item Generate \eqn{x_{3i}}{x3i} from a UNIF(1, 5) distribution and \eqn{x_{4i}}{x4i} from a UNIF(10, 14) distribution.
  \item Generate \eqn{\hat{x}_{1i}}{x.hat1i} = \eqn{x_{1i}}{x1i} + \eqn{u_{1i}}{u1i} and \eqn{\hat{x}_{2i}}{x.hat2i} = \eqn{x_{2i}}{x2i} + \eqn{u_{2i}}{u2i}.
  \item Then for each iteration, we generated \eqn{Y_{i}}{Yi} = \eqn{2 + 0.5 \hat{x}_{1i} + 0.5 \hat{x}_{2i} + 2 x_{3i} + 0.5 x_{4i} + v_{i}}{2 + 0.5*x.hat1i + 0.5*x.hat2 i + 2*x3i + 0.5*x4i + vi} and \eqn{y_{i}}{yi} = \eqn{Y_{i} + e_{i}}{Yi + ei}.
}
This data contain combination between auxiliary variable measured with error and without error.
Direct estimator \code{y}, auxiliary variable \eqn{\hat{x}_{1}}{x.hat1} \eqn{\hat{x}_{2}}{x.hat2} \eqn{x_{3}}{x3} \eqn{x_{4}}{x4}, sampling variance \eqn{\psi}{\psi}, and \eqn{c_{1} c_{2}}{c1 c2} are arranged in a dataframe called datamix.
}
