% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ek.R
\name{method_ek}
\alias{method_ek}
\title{Extract saccades using an algorithm proposed by Engbert and Kliegl (2003) \doi{10.1016/S0042-6989(03)00084-1}}
\usage{
method_ek(x, y, vel, acc, sample_rate, trial, options)
}
\arguments{
\item{x}{Gaze x coordinate, _arbitrary units_ as threshold velocity is computed in units of standard deviation.}

\item{y}{Gaze x coordinate, _arbitrary units_ as threshold velocity is computed in units of standard deviation.}

\item{vel}{Velocity \code{data.frame} with columns \code{x}, \code{y}, \code{amp}.}

\item{acc}{Acceleration \code{data.frame} with columns \code{x}, \code{y}, \code{amp}.}

\item{sample_rate}{Sample rate in Hz.}

\item{trial}{Trial id, so that trial borders are respected when computing velocity and saccades.}

\item{options}{Named list with method options. See \emph{details} for further information.}
}
\value{
logical vector marking samples that belong to saccades
}
\description{
Extract saccades using an algorithm proposed by Engbert and Kliegl (2003) \doi{10.1016/S0042-6989(03)00084-1}
}
\details{
Method options, please refer to Engbert and Kliegl (2003) for details on parameters and the rationale for default values.
\itemize{
\item{\code{ek_velocity_threshold}} {Velocity threshold for saccade detection in standard deviations. Defaults to \code{6}.}
\item{\code{ek_sd_fun}} {Function used to compute standard deviation for velocities. Defaults to \code{\link{sd_via_median_estimator}}, as per formula #2 in Engbert and Kliegl (2003). Can be replaced with \code{mad}, \code{sd}, etc.}
\item{\code{ek_minimal_duration_ms}} {Minimal duration of a saccade in milliseconds. Defaults to \code{12}.}
\item{\code{ek_minimal_separation_ms}} {A minimal required time gap between saccades. Defaults to \code{12}.}
}
}
\examples{
# Do not run this function directly, use extract_saccades() instead
}
\seealso{
\code{\link{extract_saccades}}
}
