% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmeasure_calc.R
\name{vmeasure_calc}
\alias{vmeasure_calc}
\alias{vmeasure_calc.sf}
\alias{vmeasure_calc.stars}
\alias{vmeasure_calc.SpatRaster}
\alias{vmeasure_calc.RasterLayer}
\title{V-measure calculation}
\usage{
vmeasure_calc(x, y, x_name, y_name, B = 1, precision = NULL)

\method{vmeasure_calc}{sf}(x, y, x_name, y_name, B = 1, precision = NULL)

\method{vmeasure_calc}{stars}(x, y, x_name = NULL, y_name = NULL, B = 1, precision = NULL)

\method{vmeasure_calc}{SpatRaster}(x, y, x_name = NULL, y_name = NULL, B = 1, precision = NULL)

\method{vmeasure_calc}{RasterLayer}(x, y, x_name = NULL, y_name = NULL, B = 1, precision = NULL)
}
\arguments{
\item{x}{An object of class \code{sf} with a \code{POLYGON} or \code{MULTIPOLYGON} geometry type or a spatial raster object of class \code{RasterLayer}, \code{SpatRaster}, or \code{stars}.}

\item{y}{An object of class \code{sf} with a \code{POLYGON} or \code{MULTIPOLYGON} geometry type or a spatial raster object of class \code{RasterLayer}, \code{SpatRaster}, or \code{stars}.}

\item{x_name}{A name of the column with regions/clusters names.}

\item{y_name}{A name of the column with regions/clusters names.}

\item{B}{A numeric value. If \code{B} > 1 then completeness is weighted more strongly than
homogeneity, and if \code{B} < 1 then homogeneity is weighted more strongly than
completeness. By default this value is 1.}

\item{precision}{numeric, or object of class \code{units} with distance units (but see details); see \link[sf]{st_as_binary} for how to do this.}
}
\value{
A list with five elements:
\itemize{
\item "map1" - the sf object containing the first preprocessed map used for
calculation of GOF with two attributes - \code{map1} (name of the category)
and \code{rih} (region inhomogeneity)
\item "map2" - the sf object containing the second preprocessed map used for
calculation of GOF with two attributes - \code{map1} (name of the category)
and \code{rih} (region inhomogeneity)
\item "v_measure"
\item "homogeneity"
\item "completeness"
}
}
\description{
It calculates a degree of spatial association between regionalizations using
an information-theoretical measure called the V-measure
}
\examples{
library(sf)
data("regions1")
data("regions2")
vm = vmeasure_calc(x = regions1, y = regions2, x_name = z, y_name = z)
vm

plot(vm$map1["rih"])
plot(vm$map2["rih"])

library(raster)
data("partitions1")
data("partitions2")
vm2 = vmeasure_calc(x = partitions1, y = partitions2)
vm2

plot(vm2$map1[["rih"]])
plot(vm2$map2[["rih"]])

}
\references{
Nowosad, Jakub, and Tomasz F. Stepinski.
"Spatial association between regionalizations using the information-theoretical V-measure."
International Journal of Geographical Information Science (2018).
https://doi.org/10.1080/13658816.2018.1511794

Rosenberg, Andrew, and Julia Hirschberg. "V-measure:
A conditional entropy-based external cluster evaluation measure." Proceedings
of the 2007 joint conference on empirical methods in natural language
processing and computational natural language learning (EMNLP-CoNLL). 2007.
}
