% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piping-model.R
\name{rxSetCovariateNamesForPiping}
\alias{rxSetCovariateNamesForPiping}
\title{Assign covariates for piping}
\usage{
rxSetCovariateNamesForPiping(covariates = NULL)
}
\arguments{
\item{covariates}{NULL (for no covariates), or the list of
covariates. nlmixr uses this function to set covariates if you
pipe from a nlmixr fit.}
}
\value{
Nothing, called for side effects
}
\description{
Assign covariates for piping
}
\examples{

# First set the name of known covariates
# Note this is case sensitive

rxSetCovariateNamesForPiping(c("WT","HT", "TC"))

one.compartment <- function() {
 ini({
   tka <- 0.45 ; label("Log Ka")
   tcl <- 1 ; label("Log Cl")
   tv <- 3.45 ; label("Log V")
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.err <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   d / dt(depot) <- -ka * depot
   d/dt(depot) <- -ka * depot
   d / dt(center) <- ka * depot - cl / v * center
   cp <- center / v
   cp ~ add(add.err)
 })
}

# now TC is detected as a covariate instead of a population parameter

one.compartment \%>\%
  model({ka <- exp(tka + eta.ka + TC * cov_C)})

# You can turn it off by simply adding it back

rxSetCovariateNamesForPiping()

one.compartment \%>\%
  model({ka <- exp(tka + eta.ka + TC * cov_C)})

# The covariates you set with `rxSetCovariateNamesForPiping()`
# are turned off every time you solve (or fit in nlmixr)

}
\author{
Matthew L. Fidler
}
