% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{fbpskmod}
\alias{fbpskmod}
\title{BPSK Modulator}
\usage{
fbpskmod(bits, Ns = 1, p = 1)
}
\arguments{
\item{bits}{- vector of bits (0's and 1's)}

\item{Ns}{- N samples per symbol (default, Ns = 1)}

\item{p}{- a vector defining the pulse shape of the transmitted waveform (default, p = 1)}
}
\value{
Returns a BPSK modulated vector, each element taking on values of 1 or -1. If Ns > 1
then the returned signal is shaped with pulse shape, p.
}
\description{
Receives a vector of bits, each with value 0 or 1, and outputs a
vector with values 1 and -1, respectively.
}
\examples{
bits <- sample(0:1,10, replace=TRUE)
fbpskmod(bits)
}
\seealso{
Other rwirelesscom functions: \code{\link{eyediagram}};
  \code{\link{f16pskdemod}}; \code{\link{f16pskmod}};
  \code{\link{f16qamdemod}}; \code{\link{f16qammod}};
  \code{\link{f64qamdemod}}; \code{\link{f64qammod}};
  \code{\link{f8pskdemod}}; \code{\link{f8pskmod}};
  \code{\link{fNo}}; \code{\link{fbpskdemod}};
  \code{\link{fqpskdemod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}; \code{\link{stemplot}}
}

