% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sims.R
\name{sims}
\alias{sims}
\alias{sims.rv}
\alias{sims.rvsummary}
\alias{sims.default}
\title{Retrieve the Simulations of Random Vectors}
\usage{
sims(x, ...)

\method{sims}{rvsummary}(x, dimensions = FALSE, ...)

\method{sims}{rv}(x, dimensions = FALSE, n.sims = getnsims(), ...)
}
\arguments{
\item{x}{a random variable object}

\item{\dots}{arguments passed on}

\item{dimensions}{logical, try to preserve the dimensions of \code{x}}

\item{n.sims}{(optional) number of simulations}
}
\description{
Returns the simulation matrix for the random variable object \code{x}.
}
\details{
\code{sims} returns the matrix of simulations for a given random variable
object \code{x}.

The first index of the matrix indicates the number of the simulation draw
("simulations are in rows").
}
\examples{

  setnsims(n.sims=2500)
  x <- rvnorm(24)
  dim(x) <- c(2,3,4)
  dim(sims(x))                  # 2500x24
  dim(sims(x, dimensions=TRUE)) # 2500x2x3x4

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
