% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvsample.R
\name{rvsample}
\alias{rvsample}
\title{Draw a Sample from the Simulation Matrix of a Random Variable}
\usage{
rvsample(x, size = 1, jointly = TRUE, reject.na = FALSE)
}
\arguments{
\item{x}{an object}

\item{size}{size of the sample}

\item{jointly}{return joint simulations and not simulations from each
component separately}

\item{reject.na}{reject each draw that contains an \code{NA}}
}
\value{
A \emph{numeric} array of dimensions \code{size} times
\code{length(x)}.
}
\description{
Draws a sample of desired size from each component of a given random
variable \code{x}.
}
\details{
Samples (with replacement) from the distribution of the random variable
object.  In effect it samples from the rows of the simulation matrix
\code{sims(x)}.
}
\examples{

  #

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
