% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ds_94_4}
\alias{ds_94_4}
\title{94-replicates-4-dilutions set}
\format{
\subsection{\code{ds_94_4}}{

A data frame with 17,280 rows and 9 columns:
\describe{
\item{\code{well}}{Well identifier.}
\item{\code{replicate}}{Replicate identifier.}
\item{\code{dye}}{In all reactions the SYBR Green I master mix (Roche) was used,
so the value is always \code{"SYBR"}.}
\item{\code{target}}{Target identifier: MYCN.}
\item{\code{sample_type}}{Sample type: \code{"ntc"} (no template control) or \code{"std"} (standard).}
\item{\code{copies}}{Standard copy number: either \code{0} (for NTCs), or \code{15}, \code{150},
\code{1500} or \code{15000} for standards.}
\item{\code{dilution}}{Dilution factor (the reciprocal of \code{copies}). Higher number
means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
}
\source{
\url{https://medischebiologie.nl/wp-content/uploads/2019/02/qpcrdatamethods.zip}
}
\usage{
ds_94_4
}
\description{
The 94-replicates-4-dilutions set is a dilution series consisting of four
10-fold serial dilution points, starting from 15,000 molecules down to 15
molecules, created using 10 ng/µl yeast tRNA as carrier (Roche). The same
dilution of the carrier was used to create the NTC sample.

qPCR was done on a CFX 384 instrument (Bio-Rad). A 384-well qPCR plate was prepared using a
96-well head pipetting robot (Tecan Freedom Evo 150). qPCR amplifications
were performed in 8 µl containing:
\itemize{
\item 4 µl iQ SYBR Green Supermix (Bio-Rad);
\item 0.4 µl forward and 0.4 µl reverse primer (5 µM each);
\item 0.2 µl nuclease-free water;
\item 3 µl of standard oligonucleotide.
}

A total of 94 replicated reactions were dispensed for each of 4 dilution
points. In addition, the NTC reaction was analyzed in 8 replicates.

All reactions were performed in 384-well plates (Hard-Shell 384-well
microplates and Microseal B clear using adhesive seals (Bio-Rad).

The cycling conditions were comprised of 3 min polymerase activation at 95 °C
and 45 cycles of 15 s at 95 °C and 30 s at 60 °C followed by a dissociation
curve analysis from 60 to 95 °C.
\subsection{Admonition}{

The concentration information for the curves in this data set was seemingly
incorrectly indicated (confirmed by email with the senior author Prof. Jo
Vandesompele). The annotation provided in the supplementary material that
accompanies the original publication was reversed. So, to correct for this,
the annotation of the number of copies in \code{ds_94_4} has been changed:
\itemize{
\item 15 became 15,000
\item 150 became 1,500
\item 1,500 became 150
\item 15,000 became 15
}
}
}
\keyword{datasets}
