% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_random_samples.R
\name{simulate_random_samples}
\alias{simulate_random_samples}
\title{Generate a samples for a mixture.}
\usage{
simulate_random_samples(RU_starts, RU_vec, size = 100, alpha_repunit = 1.5,
  alpha_collection = 1.5, coll_sub_dirichlet_default = 1.5)
}
\arguments{
\item{RU_starts}{a vector delineating the reporting units in \code{RU_vec};
generated by \code{tcf2param_list}}

\item{RU_vec}{a vector of collection indices, grouped by reporting unit;
generated by \code{tcf2param_list}}

\item{size}{The number of individuals desired in the mixture sample.  Default = 100.  This is
ignored without a warning if alpha_repunit is specified with counts (a cnt column) or if alpha_collection
is specified with counts (a cnt column).}

\item{alpha_repunit}{If a vector, this is the dirichlet parameter for simulating
the proportions of reporting units. Gets recycled to the number of reporting units. Default is 1.5.
Otherwise, this could be a two-column data frame.  The first column must be named "repunit" and the
second one must be one of "dirichlet", "ppn", or "cnt", according to whether you wish to
specify dirichlet parameters, or proportions, or exact counts, respectively, for each population.}

\item{alpha_collection}{The dirichlet parameter for simulating proportions of collections within reporting units. Default = 1.5}

\item{coll_sub_dirichlet_default}{If you are providing a data frame with requested sub_dirichlet pars
for collections, and you don't specifically list one, this is the value it gets.}
}
\value{
a list with three elements.
The first two are a rho vector and an omega vector, respectively. The third is a vector of origins for
simulated individuals, sampled from the collections with probabilities = omega
}
\description{
Creates random reporting unit (rho) and collection (omega) proportions, and a
\code{sim_colls} vector for simulation of individual genotypes, based on the methods
used in Hasselman \emph{et al.} (2015)
}
\keyword{internal}
