% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ts_plot}
\alias{ts_plot}
\title{ts_plot}
\usage{
ts_plot(rt, by = "days", txt = "text", filter = NULL, exclude = NULL,
  key = NULL, cols = NULL, leg.x = NULL, leg.y = NULL, lab.cex = NULL,
  lwd = NULL, ...)
}
\arguments{
\item{rt}{Tweets data frame}

\item{by}{Unit of time, e.g., \code{secs, days, weeks,
months, years}}

\item{txt}{Name of text variable in data frame which
filter is applied to.}

\item{filter}{Vector of regular expressions with which to
filter data (creating multiple time series)}

\item{exclude}{Vector of regular expressions with which to
distinguish data.}

\item{key}{Labels for filters. Defaults to actual filters.}

\item{cols}{Colors for filters}

\item{leg.x}{Location for plot text}

\item{leg.y}{Location for plot text}

\item{lab.cex}{Size of filter labels}

\item{lwd}{Width of filter lines}

\item{\dots}{Arguments passed to plot function, e.g.,
\code{main = "#rstats tweets"},
\code{xlab = "Date"},
\code{ylab = "Tweets"},
\code{main.cex = 1}.}
}
\description{
Plots frequency of tweets as time series or, if multiple
  filters (text-based criteria used to subset data) are
  specified, multiple time series.
}
\examples{
\dontrun{
## stream tweets mentioning beibs and tswift for 10 mins
rt <- rtweet::stream_tweets(
    q = "justinbieber,taylorswift13",
    timeout = (60 * 60 * 10))

## split mentions into distinct elements
mentions <- strsplit(rt$mentions_screen_name, ",")

## sorted table of mentions
mentions <- sort(table(unlist(mentions)),
    decreasing = TRUE)

## exclude biebs and tswift
mentions <- grep("justinbieber|taylorswift13", names(mentions),
    invert = TRUE, value = TRUE)

## store next most pop in obj
thirdpop <- mentions[1]

##plot with mentions as filters
ts.df <- ts_plot(rt, by = "mins", filter = c(
    "justinbieber", "taylorswift", thirdpop),
    main = "Biebs vs Tswift")

## preview returned data frame
head(ts.df)

}
}

