% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{theta2const}
\alias{theta2const}
\alias{set_theta_const}
\title{Set process probabilities to constants}
\usage{
theta2const(model, names, constants = NA)

set_theta_const(model, names, constants = NA)
}
\arguments{
\item{model}{An object of the class \code{rtmpt_model}.}

\item{names}{Character vector with process names.}

\item{constants}{Numerical vector of length one or \code{length(names)}. You have the following options for the elements of the numeric vector:
\itemize{
 \item \code{0 < constants < 1}: set the named probability to a constant value between zero and one
 \item \code{NA}: estimate the named probability
}}
}
\value{
An object of the class \code{rtmpt_model}.
}
\description{
Setting process probabilities (thetas) to constants or change it back to be estimated.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process probability for guessing (g) will be set to 0.5.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_rtmpt_model(mdl_file = mdl_2HTM)

## setting g to a constant (0.5):
new_model <- theta2const(model = model, names = c("g"), constants = c(0.5))
new_model
                    

## setting g to a constant (0.5):
new_model <- set_theta_const(model = model, names = c("g"), constants = c(0.5))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{tau2zero}}, \code{\link{theta2theta}} and \code{\link{tau2tau}}
}
\author{
Raphael Hartmann
}
