% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_resps.R
\name{set_resps}
\alias{set_resps}
\title{Set responses in a \code{rtmpt_model}}
\usage{
set_resps(model, tree, categories, values = 0)
}
\arguments{
\item{model}{A list of the class \code{rtmpt_model}.}

\item{tree}{Character or numerical value of the tree for which the responses 
should be changed.}

\item{categories}{Character or numerical vector identifying category/ies within 
the specified \code{tree} for which the responses should be changed.}

\item{values}{Numerical vector of length \code{length(categories)} providing the responses. Default is 0.}
}
\value{
A list of the class \code{rtmpt_model}.
}
\description{
Change the responses for a tree and the categories within that tree.
}
\examples{
#########################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times will be set to different values 
#   for each response.
#########################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_rtmpt_model(mdl_file = mdl_2HTM)

## changing the model to have two different encoding and response execution 
## times for "old" and "new" responses.
for(i in c(0,1)) model <- set_resps(model = model, tree = i, 
                                    categories = i*2+1, values = 1)
                                 
}
\seealso{
\code{\link{set_params}}
}
\author{
Raphael Hartmann
}
