% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_cols_by}
\alias{split_cols_by}
\title{Declaring a column-split based on levels of a variable}
\usage{
split_cols_by(
  lyt,
  var,
  labels_var = var,
  split_label = var,
  split_fun = NULL,
  format = NULL,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  ref_group = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{var}{(\code{string})\cr variable name.}

\item{labels_var}{(\code{string})\cr name of variable containing labels to be displayed for the values of \code{var}.}

\item{split_label}{(\code{string})\cr label to be associated with the table generated by the split. Not to be confused
with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{split_fun}{(\code{function} or \code{NULL})\cr custom splitting function. See \link{custom_split_funs}.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{child_labels}{(\code{string})\cr the display behavior for the labels (i.e. label rows) of the children of this
split. Accepts \code{"default"}, \code{"visible"}, and \code{"hidden"}. Defaults to \code{"default"} which flags the label row as
visible only if the child has 0 content rows.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{ref_group}{(\code{string} or \code{NULL})\cr level of \code{var} that should be considered \code{ref_group}/reference.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Will generate children for each subset of a categorical variable.
}
\section{Custom Splitting Function Details}{


User-defined custom split functions can perform any type of computation on the incoming data provided that they
meet the requirements for generating "splits" of the incoming data based on the split object.

Split functions are functions that accept:
\describe{
\item{df}{a \code{data.frame} of incoming data to be split.}
\item{spl}{a Split object. This is largely an internal detail custom functions will not need to worry about,
but \code{obj_name(spl)}, for example, will give the name of the split as it will appear in paths in the resulting
table.}
\item{vals}{any pre-calculated values. If given non-\code{NULL} values, the values returned should match these.
Should be \code{NULL} in most cases and can usually be ignored.}
\item{labels}{any pre-calculated value labels. Same as above for \code{values}.}
\item{trim}{if \code{TRUE}, resulting splits that are empty are removed.}
\item{(optional) .spl_context}{a \code{data.frame} describing previously performed splits which collectively
arrived at \code{df}.}
}

The function must then output a named \code{list} with the following elements:

\describe{
\item{values}{the vector of all values corresponding to the splits of \code{df}.}
\item{datasplit}{a list of \code{data.frame}s representing the groupings of the actual observations from \code{df}.}
\item{labels}{a character vector giving a string label for each value listed in the \code{values} element above.}
\item{(optional) extras}{if present, extra arguments are to be passed to summary and analysis functions
whenever they are executed on the corresponding element of \code{datasplit} or a subset thereof.}
}

One way to generate custom splitting functions is to wrap existing split functions and modify either the incoming
data before they are called or their outputs.
}

\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
tbl

# Let's look at the splits in more detail

lyt1 <- basic_table() \%>\% split_cols_by("ARM")
lyt1

# add an analysis (summary)
lyt2 <- lyt1 \%>\%
  analyze(c("AGE", "COUNTRY"),
    afun = list_wrap_x(summary),
    format = "xx.xx"
  )
lyt2

tbl2 <- build_table(lyt2, DM)
tbl2

# By default sequentially adding layouts results in nesting
library(dplyr)

DM_MF <- DM \%>\%
  filter(SEX \%in\% c("M", "F")) \%>\%
  mutate(SEX = droplevels(SEX))

lyt3 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by("SEX") \%>\%
  analyze(c("AGE", "COUNTRY"),
    afun = list_wrap_x(summary),
    format = "xx.xx"
  )
lyt3

tbl3 <- build_table(lyt3, DM_MF)
tbl3

# nested=TRUE vs not
lyt4 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_split_levels) \%>\%
  split_rows_by("RACE", split_fun = drop_split_levels) \%>\%
  analyze("AGE")
lyt4

tbl4 <- build_table(lyt4, DM)
tbl4

lyt5 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_split_levels) \%>\%
  analyze("AGE") \%>\%
  split_rows_by("RACE", nested = FALSE, split_fun = drop_split_levels) \%>\%
  analyze("AGE")
lyt5

tbl5 <- build_table(lyt5, DM)
tbl5

}
\author{
Gabriel Becker
}
