% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCondaEnv.R
\name{createCondaEnv}
\alias{createCondaEnv}
\alias{createCondaEnv,ANY,character-method}
\alias{createCondaEnv,ANY,missingOrNULL-method}
\alias{createCondaEnv,ANY,Session-method}
\title{Create SyncroSim package conda environments}
\usage{
createCondaEnv(pkgs, session = NULL)

\S4method{createCondaEnv}{ANY,character}(pkgs, session = NULL)

\S4method{createCondaEnv}{ANY,missingOrNULL}(pkgs, session = NULL)

\S4method{createCondaEnv}{ANY,Session}(pkgs, session = NULL)
}
\arguments{
\item{pkgs}{character or list of characters.}

\item{session}{\code{\link{Session}} object or character (i.e. filepath to a
session). If \code{NULL}, \code{session()} will be used}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful creation of the
conda environment(s)) or \code{FALSE} upon failure.
}
\description{
Creates the conda environment for the specified SyncroSim package(s).
}
\examples{
\dontrun{
# Set up a SyncroSim Session
mySession <- session()

# Create the conda environment for helloworldConda package
condaFilepath(pkgs = "helloworldConda", mySession)
}

}
