% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/published.R
\name{published}
\alias{published}
\alias{published,character-method}
\alias{published,Folder-method}
\alias{published<-}
\alias{published<-,character-method}
\alias{published<-,Folder-method}
\title{Publication status of a SyncroSim Folder}
\usage{
published(folder)

\S4method{published}{character}(folder)

\S4method{published}{Folder}(folder)

published(folder) <- value

\S4method{published}{character}(folder) <- value

\S4method{published}{Folder}(folder) <- value
}
\arguments{
\item{folder}{\code{\link{Folder}} object}

\item{value}{logical. If \code{TRUE} the Folder will be tagged for
publication and all other Folders will have publication status set to
\code{FALSE}. Default is \code{FALSE}}
}
\value{
A logical: \code{TRUE} if the Folder is tagged for publication and
\code{FALSE} otherwise.
}
\description{
Retrieves or sets the publication status of a SyncroSim \code{\link{Folder}}.
Note that only one folder can be tagged for publication at a time, so if
the publication status of a Folder is set to \code{TRUE}, then all other
Folders will have publication status set to \code{FALSE}.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myFolder <- folder(myProject, folder = "New Folder")

# Retrieve publication status of the Folder
published(myFolder)

# Set the publication status of the Folder
published(myFolder) <- TRUE
}

}
