% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_nomination.R
\name{nominations}
\alias{nominations}
\alias{cg_nomination}
\alias{cg_nominations_category}
\alias{cg_nominations_state}
\title{nominations methods}
\usage{
cg_nomination(congress, id, key = NULL, as = "table", ...)

cg_nominations_category(congress, type, key = NULL, as = "table", ...)

cg_nominations_state(congress, state, key = NULL, as = "table", ...)
}
\arguments{
\item{congress}{(integer/numeric) the Congress in which this
nomination was presented}

\item{id}{alphanumeric ID beginning with PN - for example, "PN675"}

\item{key}{your SunlightLabs API key; loads from environment variable from .Renviron or
from an option from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly)
passed on to \code{\link[crul]{HttpClient}}}

\item{type}{(character) received, updated, confirmed, or withdrawn}

\item{state}{(character) state Two-letter state abbreviation}
}
\description{
nominations methods
}
\details{
\itemize{
\item \code{cg_nomination}: Get a specific nomination
\item \code{cg_nominations_category}: Get recent nominations by categroy
\item \code{cg_nominations_state}: Get nominees by state
}
}
\examples{
\dontrun{
cg_nomination(115, "PN40")
cg_nominations_category(115, "confirmed")
cg_nominations_state(115, "VA")
}
}
