/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.EstimatetableQFSimpleStatisticsBased;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.SDMethodStats;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.FastSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.util.VKMUtil;

public abstract class SDMethod {
    protected MiningTask task;
    private Ontology ontology;
    private Options options;
    protected List<SGSelector> selectorsCache;
    private SDMethodStats methodStats;
    protected boolean aborted = false;
    protected boolean verbose = false;

    public SDMethod() {
        this.setTask(new MiningTask());
    }

    public SDMethod(MiningTask task) {
        this.setTask(task);
    }

    protected void addSubgroupToSGSet(KBestSGSet result, SG sg) {
        result.addByReplacingWorstSG(sg);
        if (this.task.isSuppressStrictlyIrrelevantSubgroups()) {
            SGSets.removeSubgroupsIrrelevantTo(sg, result);
        }
    }

    public void cancel() {
        this.aborted = true;
    }

    public SDMethodStats getMethodStats() {
        return this.methodStats;
    }

    public abstract String getName();

    public Ontology getOntology() {
        return this.ontology;
    }

    public DataView getPopulation() {
        return this.task.getOntology().getDataView();
    }

    public Options getOptions() {
        return this.options;
    }

    protected List<SGSelector> getSelectorSet(SG initialSubgroup, SGTarget target) {
        return this.selectorsCache;
    }

    private void createSelectorCache() {
        this.selectorsCache = new ArrayList<SGSelector>();
        for (SGSelector sel : this.task.getSearchSpace()) {
            if (sel instanceof DefaultSGSelector) {
                this.selectorsCache.add(new FastSelector(sel.getAttribute(), (Set)((DefaultSGSelector)sel).getValues()));
                continue;
            }
            this.selectorsCache.add(sel);
        }
    }

    public MiningTask getTask() {
        return this.task;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public final SGSet perform(Options options) {
        this.setOptions(options);
        this.createSelectorCache();
        if (this.verbose) {
            System.out.println(this.getName());
            this.setMethodStats(new SDMethodStats());
        }
        long startTimeMillis = System.currentTimeMillis();
        long startCPUTime = VKMUtil.getCpuTime();
        SGSet result = this.search(this.task.initialSG);
        this.convertFastSelectorsInResult(result);
        long endTimeMillis = System.currentTimeMillis();
        long endCPUTime = VKMUtil.getCpuTime();
        if (this.methodStats != null) {
            this.methodStats.setStartTimeMillis(startTimeMillis);
            this.methodStats.setEndTimeMillis(endTimeMillis);
            this.methodStats.setStartCPUTime(startCPUTime);
            this.methodStats.setEndCPUTime(endCPUTime);
        }
        if (this.verbose) {
            System.out.println("Time - took: " + (endTimeMillis - startTimeMillis) + " ms. (" + (endCPUTime - startCPUTime) / 1000000L + " ms. CPU time)");
            if (this.methodStats != null) {
                System.out.println("Steps: " + this.methodStats.getNodeCounter());
            }
        }
        if (this.aborted && this.verbose) {
            System.out.println(">>aborted");
        }
        return result;
    }

    protected abstract SGSet search(SG var1);

    public void createMethodStats() {
        this.methodStats = new SDMethodStats();
    }

    public void setMethodStats(SDMethodStats methodStats) {
        this.methodStats = methodStats;
    }

    protected void setOptions(Options options) {
        this.options = options;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTask(MiningTask task) {
        this.task = task;
    }

    protected boolean fullfillsMinSupportBooleanTarget(double tp, double n) {
        return this.task.fulfillsMinTPSupport(tp) && n >= this.task.getMinSubgroupSize();
    }

    protected boolean fullfillsMinSupportNumericTarget(double n) {
        return n >= this.task.getMinSubgroupSize();
    }

    private void convertFastSelectorsInResult(SGSet result) {
        for (SG sg : result) {
            FastSelector.convertToDefaultSGSelectors(sg.getSGDescription());
        }
    }

    public double getOptimisticEstimate(double subgroupSize, double subgroupPositives, double totalPopulationSize, double definedPositives) {
        double optEstimatedQuality = Double.MAX_VALUE;
        if (this.task.getQualityFunction() instanceof EstimatetableQFSimpleStatisticsBased) {
            optEstimatedQuality = ((EstimatetableQFSimpleStatisticsBased)this.task.getQualityFunction()).estimateQuality(subgroupSize, subgroupPositives, totalPopulationSize, definedPositives);
        }
        return optEstimatedQuality;
    }

    public double getOptimisticEstimateNumeric(double subgroupSize, double subgroupPositives, double totalPopulationSize, double definedPositives) {
        double optEstimatedQuality = Double.MAX_VALUE;
        if (this.task.getQualityFunction() instanceof EstimatetableQFSimpleStatisticsBased) {
            optEstimatedQuality = ((EstimatetableQFSimpleStatisticsBased)this.task.getQualityFunction()).estimateQuality(subgroupSize, subgroupPositives, totalPopulationSize, definedPositives);
        }
        return optEstimatedQuality;
    }

    public double getOptimisticEstimate(SGStatistics stats) {
        if (stats instanceof SGStatisticsBinary) {
            SGStatisticsBinary statsBin = (SGStatisticsBinary)stats;
            return this.getOptimisticEstimate(stats.getSubgroupSize(), statsBin.getTp(), stats.getDefinedPopulationCount(), statsBin.getPositives());
        }
        SGStatisticsNumeric statsNum = (SGStatisticsNumeric)stats;
        return this.getOptimisticEstimate(stats.getSubgroupSize(), statsNum.getSGMean(), stats.getDefinedPopulationCount(), statsNum.getPopulationMean());
    }

    public abstract boolean isTreatMissingAsUndefinedSupported();

    public boolean isAborted() {
        return this.aborted;
    }
}

