/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.converters.CSVDataConverter;
import org.vikamine.kernel.data.creators.AbstractOntologyCreator;
import org.vikamine.kernel.data.creators.DBConnector;
import org.vikamine.kernel.data.creators.DBDataTableCreator;

public class DBDataOntologyCreator
extends AbstractOntologyCreator {
    public DBDataOntologyCreator(DBConnector dbo, String name) throws IOException {
        this.dataset = this.importInstance(dbo, name);
    }

    public DBDataOntologyCreator(ResultSet resultset, ArrayList<String> list) {
        this.dataset = this.importInstance(resultset, list);
    }

    @Override
    public Ontology createOntology() {
        if (this.dataset != null) {
            Ontology ontology = new Ontology(this.dataset);
            ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILETYPE_PROPERTY, "database"));
            this.createIDAttribute();
            this.copyAttributesToOntology(ontology);
            return ontology;
        }
        return null;
    }

    public DataRecordSet importInstance(DBConnector dbo, String name) throws IOException {
        DataRecordSet inset = null;
        DBDataTableCreator dgb = new DBDataTableCreator(dbo, name);
        inset = CSVDataConverter.process(dgb.getTable(), CSVDataConverter.getStandardNumberFormat(), name);
        return inset;
    }

    public DataRecordSet importInstance(ResultSet resultset, ArrayList<String> list) {
        DataRecordSet inset = null;
        DBDataTableCreator dgb = new DBDataTableCreator(resultset, list);
        try {
            inset = CSVDataConverter.process(dgb.getTable(), CSVDataConverter.getStandardNumberFormat(), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inset;
    }
}

