% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cochran_qtest.R
\name{cochran_qtest}
\alias{cochran_qtest}
\title{Cochran's Q Test}
\usage{
cochran_qtest(data, formula)
}
\arguments{
\item{data}{a data frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{a ~ b | c}, where \code{a} is the
doutcome variable name; b is the within-subjects factor variables; and c
(factor) is the column name containing individuals/subjects identifier.
Should be unique per individual.}
}
\description{
Performs the Cochran's Q test for unreplicated randomized block
 design experiments with a binary response variable and paired data. This
 test is analogue to the \code{\link{friedman.test}()} with 0,1 coded
 response. It's an extension of the McNemar Chi-squared test for comparing
 more than two paired proportions.
}
\examples{
# Generate a demo data
mydata <- data.frame(
  outcome = c(0,1,1,0,0,1,0,1,1,1,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,1,1,0,0,1),
  treatment = gl(3,1,30,labels=LETTERS[1:3]),
  participant = gl(10,3,labels=letters[1:10])
)
mydata$outcome <- factor(
  mydata$outcome, levels = c(1, 0),
  labels = c("success", "failure")
  )
# Cross-tabulation
xtabs(~outcome + treatment, mydata)

# Compare the proportion of success between treatments
cochran_qtest(mydata, outcome ~ treatment|participant)

# pairwise comparisons between groups
pairwise_mcnemar_test(mydata, outcome ~ treatment|participant)

}
