% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stansim_data.R
\name{stansim_data}
\alias{stansim_data}
\title{Construct an S3 object of type stansim_data}
\usage{
stansim_data(data_name, datasets, compiled_model, input_data, param_values,
  vars)
}
\arguments{
\item{data_name}{A name attached to the \code{stansim_data} object to help
identify it. This also forms the stem of the individual .rds file names
after a call to \code{write_data()}. It is strongly recommended that an
informative name is assigned.}

\item{datasets}{A vector of names of simulated datasets.}

\item{compiled_model}{An object of S4 class \code{stanmodel}, this should be
the model provided to \code{stansim_simulate()} to simulate data from.}

\item{input_data}{Values for the data field in the provided stan model.}

\item{param_values}{A list containing the named values for the stan model
parameters used to simulate data.}

\item{vars}{The names of the stan variables saved.}
}
\value{
An S3 object of class \code{stansim_data}.
}
\description{
A constructor function for creating S3 objects of class
  \code{stansim_data}. \code{stansim_data} objects are the in-memory option
  for storing the results of a call to \code{stansim_simulate()} and feeding
  the results to \code{stansim()}.
}
