% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.multisimsum.R
\name{pattern.multisimsum}
\alias{pattern.multisimsum}
\title{pattern method for multisimsum objects}
\usage{
\method{pattern}{multisimsum}(obj, par = NULL, gpars = list(), ...)
}
\arguments{
\item{obj}{An object of class \code{multisimsum}.}

\item{par}{Estimand to plot.}

\item{gpars}{Graphical parameters. Must be a named list, with possible parameters:
\itemize{
\item \code{alpha}, alpha value of each point on the scatterplot;
\item \code{scales}, scale of \code{x} and \code{y} axis of each facet.
It is possible to redefine all the graphical parameters or a subset only; if not specified, sensible default values will be utilised. Good practice would be adding a colorblind-safe palette, e.g. using \code{\link[ggthemes:scale_color_colorblind]{ggthemes::scale_color_colorblind()}}.
}}

\item{...}{Ignored.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object that can be combined with additional \code{geom_*}, \code{scale_*}, \code{theme_*}, etc.
}
\description{
\code{\link[=pattern]{pattern()}} method for objects of class \code{multisimsum}.
}
\details{
If \code{par = NULL} (the default), all estimands are plotted and included as faceting variables.
}
\examples{
library(rsimsum)
library(ggplot2)
data("frailty", package = "rsimsum")
ms <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75),
                    estvarname = "b", se = "se", methodvar = "model",
                    by = "fv_dist", x = TRUE)
pattern(ms)
pattern(ms, par = "trt")
}
