% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{expand_geoms}
\alias{expand_geoms}
\title{Expand Geometries}
\usage{
expand_geoms(x)
}
\arguments{
\item{x}{an object of class \code{rsgeo}}
}
\value{
A list of \code{rsgeo} vectors containing each original geometry's
components as a new vector.
}
\description{
Expands geometries into a list of vectors of their components.
}
\details{
\itemize{
\item \code{rs_MULTIPOINT} expands into a vector of points
\item \code{rs_LINESTRING} expands into a vector points
\item \code{rs_MULTILINESTRING} expands into a vector of linestrings
\item \code{rs_POLYGON} expands into a vector of linestrings
\item \code{rs_MULTIPOLYGON} expands into a vector of polygons
}

If you wish to have a single vector returned, pass the results
into \code{flatten_geoms()}.
}
\examples{
mpnts <- geom_multipoint(runif(10), runif(10), rep.int(1:5, 2))
expand_geoms(mpnts)
}
