% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R, R/rtoi.R
\name{get_dir}
\alias{get_dir}
\alias{get_dir,records-method}
\alias{get_dir,records}
\alias{get_order,records-method}
\alias{get_dir,rtoi-method}
\alias{get_dir,rtoi}
\alias{get_dir<-}
\alias{get_dir,rtoi,character-generic}
\alias{get_dir<-,rtoi,character-method}
\alias{get_dir,rtoi,character-method}
\title{Get the file path of a \code{records} or an \code{rtoi}}
\usage{
get_dir(x)

\S4method{get_dir}{records}(x)

\S4method{get_order}{records}(x)

\S4method{get_dir}{rtoi}(x)

get_dir(x) <- value

\S4method{get_dir}{rtoi,character}(x) <- value
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}

\item{value}{character argument. The new directory of \code{x}.}
}
\value{
the file path in the records
}
\description{
Get the file path of a \code{records} or an \code{rtoi}
}
\examples{
# load example rtoi
navarre <- read_rtoi(system.file("ex/Navarre",package="rsat"))

# get the path of the
get_dir(navarre)

\dontrun{
# set new rtoi path
get_dir(navarre)<-"Example_path"
}

# get the records
rcds <- records(navarre)

# gets the relative path to store records data
get_dir(rcds)
}
