% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMove.R
\name{plotMove}
\alias{plotMove}
\title{plotMove}
\usage{
plotMove(x = x, y = y, size.var = NULL, fill.var = NULL,
  var.type = NULL)
}
\arguments{
\item{x}{Vector of x coordinates.}

\item{y}{Vector of y coordinates.}

\item{size.var}{Optional. Vector with elapsed time as report by \code{\link{moveReduce}}, \code{\link{sampleMove}} or \code{\link{timeDir}}. Controls the point size.}

\item{fill.var}{Optional. Vector with environmental information. Controls the fill color.}

\item{var.type}{One of 'cont' or 'cat'. Defines the type of \emph{fill.var}.}
}
\value{
A \emph{ggplot} object.
}
\description{
{Standardized plotting of environmental and temporal information for a set of coordinate pairs.}
}
\details{
{This function was designed to extent on other functions such as \code{\link{dataQuery}}, which provides environmental
information, and \code{\link{moveReduce}}, which provides information on the time spent per sample. Using these two functions
as an example, \emph{plotMove} can represent the relation between the elapsed time and the change in environmental conditions.}
}
\examples{
{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', '2013-07-16_ndvi.tif', package="rsMove"))

 # read movement data
 data(shortMove)

 # observation time
 time <- strptime(paste0(shortMove@data$date, ' ', shortMove@data$time), format="\%Y/\%m/\%d \%H:\%M:\%S")

 # reduce amount of samples
 move.reduce <- moveReduce(xy=shortMove, obs.time=time, img=r)

 # query data
 ov <- extract(r, move.reduce$points)

 # plot output
 x <- move.reduce$points@data$x
 y <- move.reduce$points@data$y
 et <- move.reduce$points@data$`Elapsed time (minutes)`
 op <- plotMove(x=x, y=y, size.var=et, fill.var=ov, var.type="cont")

}
}
\seealso{
\code{\link{dataQuery}} \code{\link{moveReduce}}
}
