% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveModel.R
\name{moveModel}
\alias{moveModel}
\title{moveModel}
\usage{
moveModel(pxy = pxy, axy = axy, label = NULL, method = NULL,
  control = NULL, nruns = 1)
}
\arguments{
\item{pxy}{Object of class \emph{SpatialPoinsDataFrame} with presence environmental variables.}

\item{axy}{Object of class \emph{SpatialPoinsDataFrame} with background environmental variables.}

\item{label}{Region labels. If missing, "pxy" is assumed as one region.}

\item{method}{Classification algorithm (see \url{http://topepo.github.io/caret/index.html}. Default is \emph{rf} (Radom Forest).}

\item{control}{Object derived by \emph{trainControl} (see \code{\link[caret]{trainControl}}). Default used out-of-bag (\emph{oob}) accuracies.}

\item{nruns}{Number of runs. Default is 1.}
}
\value{
A \emph{list}.
}
\description{
Spatially stratified predictive modeling.
}
\details{
{For n iterations, where n is the number of unique sample regions, 
the function uses one sample region for validation while the remaining ones 
are used for training. The background samples are split randomly at each 
iteration. The final accuracy, provided as a F1-score for both presence and 
background sampels, is derived from the total of true and false positives 
(\emph{$f1}). Additionaly, for each run, the function returns a model (\emph{$model}) 
which is trained using all the samples. This output can be passed to modelApply().}
}
\examples{
\dontrun{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # read example data
 file <- system.file('extdata', 'konstanz_20130805-20130811.shp', package="rsMove")
 moveData <- shapefile(file)

 # extract samples
 ot = as.Date(moveData@data$date)
 samples <- sampleMove(xy=moveData, ot=ot, error=10, method='m')

 # read remote sensing data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 
 # retrieve remote sensing data for samples
 rsQuery <- dataQuery(xy=samples,img=rsStk, rd=TRUE)
 
 # identify unique sample regions
 label <- labelSample(xy=rsQuery, rad=90, npx=1, pxr=rsStack)
 
 # select background samples
 ind <- which(label>0) # selected samples
 bSamples <- backSample(xy=moveData[ind,], rid=label[ind], img=rsStk, method='pca')
 
 # derive model predictions
 out <- moveModel(pxy=rsQuery, axy=bSamples, label=label)

}
}
\seealso{
\code{\link{sampleMove}} \code{\link{labelSample}} \code{\link{backSample}} \code{\link{modelApply}} \code{\link[caret]{train}}
}
