% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgInt.R
\name{imgInt}
\alias{imgInt}
\title{imgInt}
\usage{
imgInt(img = img, rd = rd, td = td, bs = NULL, xy = NULL)
}
\arguments{
\item{img}{Object of class \emph{RasterStack} or \emph{RasterBrick}.}

\item{rd}{Raster dates. Object of class \emph{Date}.}

\item{td}{Target dates. Object of class \emph{Date}.}

\item{bs}{Temporal buffer size (in days).}

\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}
}
\value{
A \emph{RasterBrick} or a \emph{data frame}.
}
\description{
Temporal linear interpolation of raster data.
}
\details{
{Performs a pixel-wise linear interpolation over a raster 
for a given set of dates (\emph{td}). A teporal buffer (\emph{bs}) is required 
to limit the search for reference data points (\emph{rd}). If \emph{xy} is 
provided the function only considers the pixels that overlap with 
the these sample points. Otherwise, a RasterBrick is provided.}
}
\examples{
{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # read movement data
 file <- system.file('extdata', 'konstanz_20130805-20130811.shp', package="rsMove")
 moveData <- shapefile(file)
 
 # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 rsStk <- stack(rsStk, rsStk, rsStk) # dummy files for the example
 
 # raster dates
 rd = seq.Date(as.Date("2012-01-01"), as.Date("2012-12-31"), 45)
 
 # target dates
 td = seq.Date(as.Date("2012-04-01"), as.Date("2012-08-31"), 45)
 
 # interpolate raster data to target dates
 i.img <- imgInt(img=rsStk, rd=rd, td=td, bs=60, xy=moveData)
 
}
}
\seealso{
@seealso \code{\link{dataQuery}} \code{\link{timeDirSample}} \code{\link{spaceDirSample}}
}
