% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srrr.R
\name{cv.srrr}
\alias{cv.srrr}
\title{Row-sparse reduced-rank regression tuned by cross validation}
\usage{
cv.srrr(Y, X, nrank = 1, method = c("glasso", "adglasso"), nfold = 5,
  norder = NULL, A0 = NULL, V0 = NULL, modstr = list(),
  control = list())
}
\arguments{
\item{Y}{response matrix}

\item{X}{covariate matrix}

\item{nrank}{prespecified rank}

\item{method}{group lasso or adaptive group lasso}

\item{nfold}{fold number}

\item{norder}{for constructing the folds}

\item{A0}{initial value}

\item{V0}{initial value}

\item{modstr}{a list of model parameters controlling the model
fitting}

\item{control}{a list of parameters for controlling the fitting process}
}
\value{
A list of fitting results
}
\description{
Row-sparse reduced-rank regression tuned by cross validation
}
\details{
Model parameters controlling the model fitting can be specified through
argument \code{modstr}. The available elements include
\itemize{
    \item{lamA}: tuning parameter sequence.
    \item{nlam}: number of tuning parameters; no effect if \code{lamA} is
        specified.
    \item{minLambda}: minimum lambda value, no effect if \code{lamA} is
        specified.
    \item{maxLambda}: maxmum lambda value, no effect if lamA is specified.
    \item{WA}: adaptive weights. If NULL, the weights are constructed from
        RRR.
    \item{wgamma}: power parameter for constructing adaptive weights.
}
Similarly, the computational parameters controlling optimization can be
specified through argument \code{control}. The available elements include
\itemize{
    \item{epsilon}: epsilonergence tolerance.
    \item{maxit}: maximum number of iterations.
    \item{inner.eps}: used in inner loop.
    \item{inner.maxit}: used in inner loop.
}
}
\references{
Chen, L. and Huang, J.Z. (2012) Sparse reduced-rank regression for
simultaneous dimension reduction and variable selection. \emph{Journal of
the American Statistical Association}. 107:500, 1533--1545.
}
