/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import org.openjena.atlas.lib.Lib;

public class OpExtend
extends Op1 {
    private VarExprList assignments;

    public static Op extend(Op op, Var var, Expr expr) {
        if (!(op instanceof OpExtend)) {
            return OpExtend.createExtend(op, var, expr);
        }
        OpExtend opAssign = (OpExtend)op;
        if (opAssign.assignments.contains(var)) {
            return OpExtend.createExtend(op, var, expr);
        }
        opAssign.assignments.add(var, expr);
        return opAssign;
    }

    public static Op extend(Op op, VarExprList exprs) {
        if (!(op instanceof OpExtend)) {
            return OpExtend.createExtend(op, exprs);
        }
        OpExtend opAssign = (OpExtend)op;
        for (Var var : exprs.getVars()) {
            if (!opAssign.assignments.contains(var)) continue;
            return OpExtend.createExtend(op, exprs);
        }
        opAssign.assignments.addAll(exprs);
        return opAssign;
    }

    public static OpExtend extendDirect(Op op, VarExprList exprs) {
        return new OpExtend(op, exprs);
    }

    private static Op createExtend(Op op, Var var, Expr expr) {
        VarExprList x = new VarExprList();
        x.add(var, expr);
        return new OpExtend(op, x);
    }

    private static Op createExtend(Op op, VarExprList exprs) {
        VarExprList x = new VarExprList();
        x.addAll(exprs);
        return new OpExtend(op, x);
    }

    private OpExtend(Op subOp) {
        super(subOp);
        this.assignments = new VarExprList();
    }

    private OpExtend(Op subOp, VarExprList exprs) {
        super(subOp);
        this.assignments = exprs;
    }

    public String getName() {
        return "extend";
    }

    private void add(Var var, Expr expr) {
        this.assignments.add(var, expr);
    }

    public VarExprList getVarExprList() {
        return this.assignments;
    }

    public int hashCode() {
        return this.assignments.hashCode() ^ this.getSubOp().hashCode();
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        OpExtend op = new OpExtend(subOp, new VarExprList(this.getVarExprList()));
        return op;
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpExtend)) {
            return false;
        }
        OpExtend assign2 = (OpExtend)other;
        if (!Lib.equal(this.assignments, assign2.assignments)) {
            return false;
        }
        return this.getSubOp().equalTo(assign2.getSubOp(), labelMap);
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }
}

