/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class ModLARQindex
implements ArgModuleGeneral {
    ArgDecl argIndex = new ArgDecl(true, "larq", "lucene", "index");
    String luceneDir;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("LARQ");
        cmdLine.add(this.argIndex, "--larq=DIR", "Index directory");
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (!cmdLine.contains(this.argIndex)) {
            throw new CmdException("No index");
        }
        this.luceneDir = cmdLine.getValue(this.argIndex);
    }

    public IndexLARQ getIndexLARQ() {
        try {
            FSDirectory dir = FSDirectory.getDirectory((String)this.luceneDir);
            IndexReader indexReader = IndexReader.open((Directory)dir);
            return new IndexLARQ(indexReader);
        }
        catch (Exception ex) {
            throw new ARQLuceneException("LARQ", ex);
        }
    }

    public IndexWriter getIndexWriter() {
        try {
            FSDirectory dir = FSDirectory.getDirectory((String)this.luceneDir);
            IndexWriter indexWriter = new IndexWriter((Directory)dir, (Analyzer)new StandardAnalyzer());
            return indexWriter;
        }
        catch (Exception ex) {
            throw new ARQLuceneException("LARQ", ex);
        }
    }
}

