% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{rrda.plot}
\alias{rrda.plot}
\title{Plot the results of cross-validation for Bhat obtained from the \code{rrda.cv} function.}
\usage{
rrda.plot(
  cv_result,
  nrank = NULL,
  min_l = NULL,
  max_l = NULL,
  show_error_bar = FALSE,
  title = NULL
)
}
\arguments{
\item{cv_result}{A result list from the function \code{rrda.cv}, containing a matrix of MSE values for each rank and lambda, and a vector of lambda values.}

\item{nrank}{A numeric vector specifying the ranks of Bhat to be plotted. Default is \code{NULL}, which plots all ranks.}

\item{min_l}{Minimum lambda value to be plotted. Default is \code{NULL}, which uses the minimum lambda value in \code{cv_result}.}

\item{max_l}{Maximum lambda value to be plotted. Default is \code{NULL}, which uses the maximum lambda value in \code{cv_result}.}

\item{show_error_bar}{Logical value indicating if the error bar is shown on the line that gives the best MSE value.}

\item{title}{Title of the figure}
}
\value{
A plot of MSE cross-validation results.
}
\description{
This function visualizes the results of cross-validation for the estimated Bhat matrix obtained from the rrda.cv function. It creates a plot of the Mean Squared Error (MSE) for each combination of rank and lambda regularization parameter, allowing for the selection of specific ranks and lambda ranges to be plotted. Error bars representing the standard error of the MSE can be displayed for the best rank.
}
\examples{
set.seed(10)
simdata<-rdasim1(n = 10,p = 30,q = 30,k = 3) # data generation
X <- simdata$X
Y <- simdata$Y

cv_result<- rrda.cv(Y = Y, X = X, maxrank = 5, nfold = 5) # cv
rrda.summary(cv_result = cv_result)
rrda.plot(cv_result = cv_result)
}
