% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_atld.R
\name{cp_atld}
\alias{cp_atld}
\title{Alternating Trilinear Decomposition (ATLD) for Candecomp/Parafac (CP)}
\usage{
cp_atld(
  X,
  n,
  m,
  p,
  ncomp,
  conv = 1e-06,
  start = "random",
  maxit = 5000,
  trace = FALSE
)
}
\arguments{
\item{X}{A three-way array or a matrix. If \code{X} is a matrix
(matricised threeway array), \code{n}, \code{m} and \code{p} must be
given and are the number of A-, B- and C-mode entities respectively}

\item{n}{Number of A-mode entities}

\item{m}{Number of B-mode entities}

\item{p}{Number of C-mode entities}

\item{ncomp}{Number of components to extract}

\item{conv}{Convergence criterion, default is \code{conv=1e-6}.}

\item{start}{Initial values for the A, B and C components. Can be
\code{"svd"} for starting point of the algorithm from SVD's,
\code{"random"} for random starting point (orthonormalized
component matrices or nonnegative matrices in case of nonnegativity
constraint), or a list containing user specified components.}

\item{maxit}{Maximum number of iterations, default is \code{maxit=10000}.}

\item{trace}{Logical, provide trace output.}
}
\value{
The result of the decomposition as a list with the following
 elements:
   \itemize{
   \item \code{fit} Value of the loss function
   \item \code{fp} Fit value expressed as a percentage
   \item \code{ss} Sum of squares
   \item \code{A} Component matrix for the A-mode
   \item \code{B} Component matrix for the B-mode
   \item \code{C} Component matrix for the C-mode
   \item \code{iter} Number of iterations
   \item \code{tripcos} Minimal triple cosine between two components
       across the three component matrices, used to inspect degeneracy
   \item \code{mintripcos} Minimal triple cosine during the iterative
       algorithm observed at every 10 iterations, used to inspect degeneracy
   \item \code{ftiter} Matrix containing in each row the function value
       and the minimal triple cosine at every 10 iterations
   }
}
\description{
Alternating Trilinear Decomposition algorithm for estimating
 the Candecomp/Parafac (CP) model. It is based on an alternating least squares
 principle and replaces the iterative procedure used in the traditional
 PARAFAC algorithm by an improved procedure. This improved procedure
 contains Moore-Penrose pseudoinverse computations based on singular
 value decomposition (SVD) which should be theoretically more robust
 to similarities in spectra and time profiles
}
\examples{

\dontrun{
## Example with the OECD data
 data(elind)
 dim(elind)

 res <- cp_atld(elind, ncomp=3)
 res$fp
 res$fp
 res$iter
}
}
\references{
H.-L. Wu, M. Shibukawa, K. Oguma, An alternating trilinear decomposition
 algorithm with application to calibration of HPLC-DAD for
 simultaneous determination of overlapped chlorinated aromatic hydrocarbons,
 \emph{Journal of Chemometrics} \bold{12} (1998) 1--26.
}
\author{
Valentin Todorov, \email{valentin.todorov@chello.at}; Violetta Simonacci, \email{violetta.simonacci@unina.it}
}
