% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reexports.R
\name{reticulate-reexports}
\alias{reticulate-reexports}
\alias{import_main}
\alias{tuple}
\alias{py_tuple}
\alias{py_help}
\alias{np_array}
\alias{import}
\alias{r_to_py}
\alias{py_to_r}
\alias{py_to_r_wrapper}
\alias{py_str}
\alias{py_run_string}
\alias{py_bool}
\alias{py_dict}
\alias{py_call}
\alias{py_del_attr}
\alias{py_del_item}
\alias{py_eval}
\alias{py_get_attr}
\alias{py_set_attr}
\alias{py_get_item}
\alias{py_set_item}
\alias{py_len}
\alias{py_none}
\title{Wrappers around \code{'reticulate'} package}
\usage{
import_main(convert = FALSE)

tuple(..., convert = FALSE)

py_tuple(..., convert = FALSE)

py_help(object)

np_array(data, ...)

import(module, as = NULL, convert = FALSE, delay_load = FALSE)

r_to_py(x, convert = FALSE)

py_to_r(x)

py_to_r_wrapper(x)

py_str(object, ...)

py_run_string(code, local = TRUE, convert = FALSE)

py_bool(x)

py_dict(keys, values, convert = FALSE)

py_call(x, ...)

py_del_attr(x, name)

py_del_item(x, name)

py_eval(code, convert = FALSE)

py_get_attr(x, name, silent = FALSE)

py_set_attr(x, name, value)

py_get_item(x, key, silent = FALSE)

py_set_item(x, name, value)

py_len(x, default = NULL)

py_none()
}
\arguments{
\item{convert}{whether to convert \code{'Python'} objects to R; default is
\code{FALSE}. This is different to \code{'reticulate'}, but less error prone:
users must explicitly convert \code{'Python'} objects to R.}

\item{object, data, x, code, keys, values, ...}{passed to corresponding
\code{'reticulate'} functions as data inputs}

\item{module, as, delay_load}{import \code{'Python'} module as alias}

\item{local}{whether to execute code locally so the memory sets free when the
function ends; default is true}

\item{name, silent, key, value, default}{other parameters passing to the
\code{'reticulate'} functions}
}
\value{
\code{'Python'} built-in objects
}
\description{
Almost the same with \code{'reticulate'} functions, with
\code{rpymat} enabled by default and some minor changes
(see parameter \code{convert} and \code{local})
}
\examples{

library(rpymat)
if(interactive() && dir.exists(env_path())) {

  # tuple
  x <- tuple(1, 2, "a")
  print(x)

  # convert to R object
  py_to_r(x)

  # convert R object to python
  y <- r_to_py(list(a = 1, b = "s"))

  # get element
  py_get_item(y, "a")

  # get missing element
  py_get_item(y, "c", silent = TRUE)

}

}
