% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_ANTsImage}
\alias{as_ANTsImage}
\title{Load data as \code{'ANTsImage'} class}
\usage{
as_ANTsImage(x, strict = FALSE)
}
\arguments{
\item{x}{data to be converted; this can be an \code{'ANTsImage'} instance,
character, \code{'oro.nifti'} object, \code{'niftiImage'} from
package \code{'RNifti'}, or \code{'threeBrain.nii'} from package
\code{'threeBrain'}}

\item{strict}{whether \code{x} should not be \code{NULL}}
}
\value{
An \code{'ANTsImage'} instance; use \code{ants$ANTsImage} to see
the 'Python' documentation
}
\description{
Load data as \code{'ANTsImage'} class
}
\examples{

if(interactive() && ants_available()) {

  ants <- load_ants()

  # Python string
  x1 <- ants$get_ants_data('r16')
  as_ANTsImage( x1 )

  # R character
  nii_path <- system.file(package = "RNifti",
                          "extdata", "example.nii.gz")
  as_ANTsImage( nii_path )

  # niftiImage object
  x2 <- RNifti::readNifti(nii_path)
  as_ANTsImage( x2 )

}

}
