% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pgTrajViewParams}
\alias{pgTrajViewParams}
\title{Computes the trajectory parameters (as in ltraj) for a pgtraj and 
creates a view for the pgtraj. The views are always named as 
'parameters_<pgtraj_name>'.}
\usage{
pgTrajViewParams(conn, schema, pgtraj, epsg, db = TRUE)
}
\arguments{
\item{conn}{Connection object created with RPostgreSQL}

\item{schema}{String. Name of the schema that stores or will store the 
pgtraj data model.}

\item{pgtraj}{String. Name of the pgtraj.}

\item{epsg}{Numeric. EPSG code of the relocation geometry.}

\item{db}{Boolean. A switch that controls the parameters view creation 
depending on source of data (R or PostgreSQL). If TRUE, raw data input 
from a database table is assumed. In this case all parameters will be 
computed. If FALSE, it is assumed that an ltraj was input from R with 
already computed parameters. In this case R2n and rel.angle will not 
be recomputed, but reused from the ltraj.}
}
\value{
TRUE on success, otherwise warning/error
}
\description{
Computes the trajectory parameters (as in ltraj) for a pgtraj and 
creates a view for the pgtraj. The views are always named as 
'parameters_<pgtraj_name>'.
}
\author{
Balázs Dukai
}
\keyword{internal}

