#include "rexp_rpgm.h"

	//xm[-1] = 0.
static double xm[256] = {0.0911031208568659, 0.130527629109185, 0.161501642064202, 0.188123681593812, 0.211979373202764, 0.233881068922722, 0.254310826520826, 0.273582468865909, 0.291913768403291, 0.309463155727526, 0.32635016790036, 0.342667601258015, 0.358489197897193, 0.37387474683286, 0.388873493151397, 0.403526563175477, 0.417868766351235, 0.43192985306876, 0.445735468422951, 0.459307963163534, 0.472666911508542, 0.485829596778668, 0.498811354781562, 0.511625897081203, 0.524285523063809, 0.536801335267003, 0.549183377534328, 0.561440800842924, 0.573581933241504, 0.585614432711075, 0.597545310836646, 0.609381063556185, 0.621127675403526, 0.632790693013542, 0.64437529706132, 0.655886275601988, 0.66732814373824, 0.678705105875297, 0.690021106576953, 0.701279866185362, 0.712484869112535, 0.723639434890012, 0.734746669919134, 0.745809532744565, 0.756830829936575, 0.767813233915255, 0.778759280803137, 0.789671379714026, 0.800551856593643, 0.811402900124982, 0.822226652385507, 0.833025121860593, 0.843800265449254, 0.854553958701177, 0.865288000002047, 0.876004127326126, 0.886704024204109, 0.897389301769295, 0.908061541840749, 0.91872225529503, 0.929372926556841, 0.940014971558038, 0.9506498095559, 0.96127875669838, 0.971903163910357, 0.982524310096308, 0.993143436982514, 1.00376178637206, 1.01438055717182, 1.02500092939275, 1.03562404755425, 1.04625104580476, 1.05688304597991, 1.0675211119703, 1.07816636287775, 1.08881981134982, 1.09948253676265, 1.11015556627249, 1.12083990149836, 1.13153654703885, 1.14224652523038, 1.15297079685522, 1.16371035281111, 1.17446615002721, 1.18523917405312, 1.19603035698381, 1.20684065715792, 1.21767100899239, 1.22852238908192, 1.23939571401383, 1.25029192344959, 1.26121194524745, 1.27215671179568, 1.28312717746217, 1.29412426425727, 1.30514889607472, 1.31620203527946, 1.32728458977807, 1.33839750446666, 1.34954174325098, 1.36071823082724, 1.3719279482319, 1.38317181562991, 1.39445082919106, 1.40576594229919, 1.41711812416671, 1.42850835996478, 1.43993765095399, 1.45140699326981, 1.46291739841115, 1.47446989333409, 1.48606547634733, 1.49770520404344, 1.50939012607403, 1.52112132967236, 1.53289984841563, 1.54472679876959, 1.55660328937364, 1.56853044368171, 1.58050935140211, 1.59254123763234, 1.6046271965515, 1.61676845946412, 1.62896622390239, 1.64122167636251, 1.65353612129922, 1.66591080235503, 1.67834697784657, 1.69084600204563, 1.70340916544697, 1.71603785647795, 1.72873342586392, 1.74149732570448, 1.75433097041461, 1.76723582087962, 1.78021338630482, 1.79326516606384, 1.80639276953041, 1.81959773702395, 1.83288172135018, 1.84624636731056, 1.8596934060296, 1.87322456173766, 1.88684161572901, 1.90054634184537, 1.91434067389255, 1.92822650887248, 1.94220577232413, 1.95628048928879, 1.97045271783938, 1.98472454950067, 1.99909818348746, 2.01357578269249, 2.0281596968212, 2.04285224265472, 2.05765577745825, 2.07257285852357, 2.0876059735434, 2.10275777822749, 2.11803094024678, 2.13342822168219, 2.14895252631812, 2.16460673347428, 2.18039391396919, 2.19631720725402, 2.21237982333072, 2.22858504473524, 2.2449363701845, 2.26143728855171, 2.27809156635296, 2.29490286984645, 2.31187520571727, 2.32901253488553, 2.34631918095019, 2.36379937826463, 2.38145769071824, 2.39929875990418, 2.41732736157113, 2.43554863944293, 2.45396772490648, 2.47259002416621, 2.49142123617098, 2.51046712573601, 2.52973377147454, 2.54922752286419, 2.56895501663806, 2.58892312785781, 2.60913898214253, 2.6296100380651, 2.65034410836418, 2.67134945517226, 2.69263452720097, 2.71420826488572, 2.73607998252041, 2.75825954840832, 2.78075718502498, 2.80358365222191, 2.82675037038028, 2.85026921333092, 2.87415271157476, 2.89841410210491, 2.92306719707516, 2.94812670630803, 2.97360831368486, 2.99952815941599, 3.02590388396355, 3.05275372236984, 3.08009718203656, 3.10795516049358, 3.1363497316602, 3.16530424244314, 3.19484390785115, 3.22499550139066, 3.25578762478255, 3.28725115285346, 3.31941878567646, 3.35232620935411, 3.38601156030975, 3.42051597822602, 3.45588394087874, 3.49216381175055, 3.52940814121663, 3.56767400188337, 3.60702354713837, 3.64752504364181, 3.68925330991069, 3.73229103426254, 3.77672883993912, 3.82266777861871, 3.87022003627317, 3.91951070201887, 3.97068017180926, 4.02388710595056, 4.0793103260372, 4.13715413636111, 4.19765216624673, 4.26107349665562, 4.32773086973891, 4.3979909658777, 4.47228485187767, 4.55112856979989, 4.63514236991333, 4.72508552493772, 4.82189683582138, 4.92675929049025, 5.04119369253292, 5.16719695750902, 5.30747007378476, 5.4657920252968, 5.64768613722233, 5.86169312809321, 6.12208350235214, 6.45551776143252, 6.92162579381814, 7.70960135256662, 22.1807097779182};

	//ym[-1] = 1.
static double ym[256] = {0.912923564584892, 0.877632244416652, 0.850865134289049, 0.828512229182489, 0.808981384089382, 0.791455939005835, 0.775450733929536, 0.760649603858976, 0.74683293379311, 0.733840808731174, 0.721552478672594, 0.709874133616921, 0.6987311735638, 0.688063088512944, 0.677820013464113, 0.66796028341711, 0.658448633371767, 0.649254918327939, 0.640353143285503, 0.63172066824435, 0.623337663204387, 0.615186628165529, 0.607252038127704, 0.599520028090844, 0.591978168054891, 0.584615253019791, 0.577421152985495, 0.57038665795196, 0.563503387919147, 0.556763662887017, 0.550160452855539, 0.54368727282468, 0.537338152794413, 0.53110757276471, 0.524990402735549, 0.518981897706905, 0.513077617678759, 0.507273432651089, 0.501565482623878, 0.495950147597109, 0.490424042570765, 0.484983972544831, 0.479626947519293, 0.474350142494138, 0.469150892469352, 0.464026677444924, 0.458975117420843, 0.453993962397097, 0.449081067373676, 0.444234412350571, 0.439452057327773, 0.434732177305272, 0.430073022283062, 0.425472927261132, 0.420930307239477, 0.416443647218088, 0.412011497196959, 0.407632477176084, 0.403305257155455, 0.399028572135067, 0.394801202114915, 0.390621987094992, 0.386489797075293, 0.382403572055813, 0.378362267036548, 0.374364892017491, 0.37041049699864, 0.366498156979989, 0.362626986961535, 0.358796131943273, 0.355004771925199, 0.351252111907309, 0.3475373818896, 0.343859851872069, 0.340218791854711, 0.336613526837524, 0.333043376820505, 0.32950769680365, 0.326005866786956, 0.32253728177042, 0.319101346754041, 0.315697501737814, 0.312325191721738, 0.308983886705809, 0.305673061690026, 0.302392221674386, 0.299140876658886, 0.295918556643525, 0.292724791628299, 0.289559141613208, 0.286421171598249, 0.28331046158342, 0.280226601568718, 0.277169186554143, 0.274137831539692, 0.271132161525364, 0.268151801511156, 0.265196401497067, 0.262265611483095, 0.259359086469239, 0.256476501455497, 0.253617526441868, 0.25078185642835, 0.247969176414942, 0.245179191401641, 0.242411611388448, 0.23966615137536, 0.236942531362376, 0.234240481349495, 0.231559736336715, 0.228900036324036, 0.226261136311456, 0.223642786298974, 0.221044746286588, 0.218466776274299, 0.215908656262104, 0.213370156250002, 0.210851056237993, 0.208351141226076, 0.205870211214249, 0.203408046202511, 0.200964461190862, 0.198539251179301, 0.196132226167826, 0.193743206156437, 0.191371996145133, 0.189018421133913, 0.186682311122777, 0.184363486111723, 0.18206178610075, 0.179777041089858, 0.177509096079047, 0.175257786068314, 0.17302296105766, 0.170804471047084, 0.168602166036586, 0.166415906026163, 0.164245541015817, 0.162090941005546, 0.159951965995349, 0.157828485985226, 0.155720365975176, 0.153627480965199, 0.151549705955294, 0.14948692594546, 0.147439010935697, 0.145405845926005, 0.143387320916382, 0.141383320906829, 0.139393735897344, 0.137418460887928, 0.135457385878579, 0.133510415869297, 0.131577440860082, 0.129658365850934, 0.127753100841851, 0.125861540832834, 0.123983600823881, 0.122119185814993, 0.12026821080617, 0.118430590797409, 0.116606235788712, 0.114795070780078, 0.112997010771506, 0.111211975762997, 0.109439890754549, 0.107680685746163, 0.105934280737837, 0.104200610729573, 0.102479595721368, 0.100771180713224, 0.0990752907051393, 0.0973918706971141, 0.0957208456891481, 0.0940621656812408, 0.0924157656733922, 0.0907815906656018, 0.0891595906578695, 0.0875497006501949, 0.0859518756425778, 0.0843660656350179, 0.0827922156275152, 0.0812302856200691, 0.0796802306126797, 0.0781420056053468, 0.0766155655980699, 0.0751008705908491, 0.0735978855836842, 0.0721065755765748, 0.070626905569521, 0.0691588355625224, 0.0677023405555791, 0.0662573905486907, 0.0648239605418574, 0.0634020205350787, 0.0619915505283548, 0.0605925305216855, 0.0592049355150706, 0.05782875050851, 0.0564639605020039, 0.0551105504955519, 0.0537685154891542, 0.0524378454828107, 0.0511185254765213, 0.049810565470286, 0.0485139504641048, 0.0472286904579777, 0.0459547904519049, 0.0446922504458861, 0.0434410804399216, 0.0422013004340114, 0.0409729204281555, 0.039755960422354, 0.0385504454166071, 0.0373563954109148, 0.0361738504052774, 0.0350028353996951, 0.0338433903941677, 0.0326955603886958, 0.0315593953832796, 0.0304349453779191, 0.0293222653726148, 0.0282214203673669, 0.0271324853621757, 0.0260555353570417, 0.0249906553519653, 0.0239379303469468, 0.0228974703419867, 0.0218693803370856, 0.0208537803322441, 0.0198508053274628, 0.0188606003227423, 0.0178833153180834, 0.0169191303134869, 0.0159682303089539, 0.0150308253044851, 0.0141071503000818, 0.0131974602957451, 0.0123020302914765, 0.0114211902872773, 0.0105552852831494, 0.00970472527909461, 0.00886995527511514, 0.00805150027121349, 0.00724996026739233, 0.00646602526365525, 0.00570052526000597, 0.00495444525644928, 0.00422899025299084, 0.00352566524963804, 0.00284642024639992, 0.00219388024328915, 0.00157182524032373, 0.000986225237532112, 0.000448500234968674, 2.3283064365387e-10};


void rexp_vect(int N, double * vector, SEXP * lambda)
{
	unsigned int A;
	double u;

	static unsigned char j=0;
	static unsigned int u0;
	
	double* lambda_vect = REAL(*lambda);
		
	int n_lambda = length(*lambda);

	for(int i=0 ; i != N ; ++i)
	{
		if(!j)
		{
			u0 = mt_rand();
			j=3;
		}
		else
		{
			--j;
		}
		A =  u0 & 255;
		u0 >>= 8;

		vector[i] = 0.;
		while(!vector[i])
		{
			u = unif_rand()*xm[A];
			if(A != 0 && (u <= xm[A-1])) 
			{
				vector[i] = lambda_vect[i % n_lambda]*u;
			}
			else
			{
				if(runif(ym[A], (A ? ym[A-1] : 1.)) <= exp(-u))
				{
					vector[i] = lambda_vect[i % n_lambda]*u; 
				}
			}
		}
	}
}


void rexp_rpgm(int N, double * vector, double inv_lambda)
{
	unsigned int A;
	double u;

	static unsigned char j=0;
	static unsigned int u0;
	
	for(int i=0 ; i != N ; ++i)
	{
		if(!j)
		{
			u0 = mt_rand();
			j=3;
		}
		else
		{
			--j;
		}
		A =  u0 & 255;
		u0 >>= 8;

		vector[i] = 0.;
		while(!vector[i])
		{
			u = unif_rand()*xm[A];
			if(A != 0 && (u <= xm[A-1])) //prcalculer xm[A] / xm[A-1] pour comparer U0. Et mme prcalculer Max_MT*(xm[A] / xm[A-1]) en integer pour comparaison avec mt_rand()
			{
				vector[i] = inv_lambda*u; 
			}
			else
			{
				if(runif(ym[A], (A ? ym[A-1] : 1.)) <= exp(-u))
				{
					vector[i] = inv_lambda*u;
				}
			}
		}
	}
}

// [[register]]
SEXP re(SEXP n, SEXP lambda)
{
	int N;
	
	double inv_lambda;

	
	if(TYPEOF(n) == INTSXP)
		N=*INTEGER(n);
	else if(TYPEOF(n) == REALSXP)
		N = (int) *REAL(n);
	else
		N = 0;

	SEXP vector_sexp;
	double* vector;
	PROTECT(vector_sexp = allocVector(REALSXP, N));
	vector = REAL(vector_sexp);
	


	if(length(lambda) == 1)
	{
		if(TYPEOF(lambda) == REALSXP)
		{
			inv_lambda = 1/(*REAL(lambda));
		}
		else if(TYPEOF(lambda) == INTSXP)
		{
			inv_lambda = 1/((double) *INTEGER(lambda));
		}
		else
		{
			inv_lambda = 0.;
		}
		
			rexp_rpgm(N, vector, inv_lambda);
	}
	else
	{
		rexp_vect(N, vector, &lambda);
	}

	UNPROTECT(1);

	return vector_sexp;
}

void rgeom_rpgm(int N, int * vector, double p)
{
	unsigned int A;
	double u;
	
	double inv_lambda = -1/log(1-p);

	static unsigned char j=0;
	static unsigned int u0;
	
	for(int i=0 ; i != N ; ++i)
	{
		if(!j)
		{
			u0 = mt_rand();
			j=3;
		}
		else
		{
			--j;
		}
		A =  u0 & 255;
		u0 >>= 8;

		vector[i] = -1;
		while(vector[i] < 0)
		{
			u = unif_rand()*xm[A];
			if(A != 0 && (u <= xm[A-1])) //précalculer xm[A] / xm[A-1] pour comparer U0. Et même précalculer Max_MT*(xm[A] / xm[A-1]) en integer pour comparaison avec mt_rand()
			{
				vector[i] = (int) (inv_lambda*u); 
			}
			else
			{
				if(runif(ym[A], (A ? ym[A-1] : 1.)) <= exp(-u))
				{
					vector[i] = (int) (inv_lambda*u);
				}
			}
		}
	}
}



// [[register]]
SEXP rg(SEXP n, SEXP p)
{
	int N;
	
	double p0;
	
	if(TYPEOF(n) == INTSXP)
		N=*INTEGER(n);
	else if(TYPEOF(n) == REALSXP)
		N = (int) *REAL(n);
	else
		N = 0;

	SEXP vector_sexp;
	int* vector;
	PROTECT(vector_sexp = allocVector(INTSXP, N));
	vector = INTEGER(vector_sexp);
	


	if(length(p) == 1)
	{
		if(TYPEOF(p) == REALSXP)
		{
			p0 = *REAL(p);
			if(p0 <= 0. || p0 > 1.)
			{
				for(int i = 0 ; i != N ; i++)
					vector[i] = NA_INTEGER;
				UNPROTECT(1);
				return vector_sexp;
			}
		}
		else
		{
			for(int i = 0 ; i != N ; i++)
				vector[i] = NA_INTEGER;
			UNPROTECT(1);
			return vector_sexp;
		}
		rgeom_rpgm(N, vector, p0);
	}
	else
	{
//		rgeom_vect(N, vector, &p);
		rgeom_rpgm(N, vector, *REAL(p));
	}

	UNPROTECT(1);

	return vector_sexp;
}

