% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoclim.R
\name{paleoclim}
\alias{paleoclim}
\title{Retrieve data from PaleoClim}
\usage{
paleoclim(
  period = c("lh", "mh", "eh", "yds", "ba", "hs1", "lig", "mis19", "mpwp", "m2", "cur",
    "lgm"),
  resolution = c("10m", "5m", "2_5m", "30s"),
  region = NULL,
  as = c("terra", "raster"),
  skip_cache = FALSE,
  cache_path = fs::path_temp(),
  quiet = FALSE
)
}
\arguments{
\item{period}{Character. Time period to retrieve.}

\item{resolution}{Character. Resolution to retrieve.}

\item{region}{\code{SpatExtent} object or object that can be coerced to
\code{SpatExtent} (see \code{\link[terra:ext]{terra::ext()}}), describing the
region to be retrieved. If \code{NULL}, defaults to the whole
globe.}

\item{as}{Character. \code{as = "raster"} returns a \code{RasterStack} object
(see \code{\link[raster:stack]{raster::stack()}}) instead of the default raster from
the \code{terra} package. It is provided for backwards
compatibility and will be removed in future versions.
Requires the \code{raster} and \code{rgdal} packages.}

\item{skip_cache}{Logical. If \code{TRUE}, cached data will be ignored.}

\item{cache_path}{Logical. Path to directory where downloaded files should
be saved. Defaults to R's temporary directory.}

\item{quiet}{Logical. If \code{TRUE}, suppresses messages and download
progress information.}
}
\value{
\code{SpatRaster} object (see \code{\link[terra:rast]{terra::rast()}}) with each bioclimatic variable
as a separate named layer.
}
\description{
Downloads data from PaleoClim (\url{http://www.paleoclim.org}) and loads it into R
as a \code{SpatRaster} object.
}
\details{
See \url{http://www.paleoclim.org} for details of the datasets and codings.
Data at 30s resolution is only available for 'cur' and 'lgm'.

By default, \code{paleoclim()} will read previously downloaded files in R's
temporary directory if available. Use \code{skip_cache = TRUE} to override this.
\code{cache_path} can also be set to another directory. This can be useful if you
want to reuse downloaded data between sessions.
}
\examples{
\dontshow{if (interactive() && curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
paleoclim("lh", "10m")
\dontshow{\}) # examplesIf}
}
