% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getSampleSizeRates}
\alias{getSampleSizeRates}
\title{Get Sample Size Rates}
\usage{
getSampleSizeRates(
  design = NULL,
  ...,
  groups = 2,
  normalApproximation = TRUE,
  riskRatio = FALSE,
  thetaH0 = ifelse(riskRatio, 1, 0),
  pi1 = c(0.4, 0.5, 0.6),
  pi2 = 0.2,
  allocationRatioPlanned = NA_real_
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{normalApproximation}{If \code{FALSE}, the sample size
for the case of one treatment group is calculated exactly using the binomial distribution,
default is \code{TRUE}.}

\item{riskRatio}{If \code{TRUE}, the sample size for one-sided
testing of H0: \code{pi1 / pi2 = thetaH0} is calculated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{pi1}{A numeric value or vector that represents the assumed probability in
the active treatment group if two treatment groups
are considered, or the alternative probability for a one treatment group design,
default is \code{seq(0.2, 0.5, 0.1)} (power calculations and simulations) or
\code{seq(0.4, 0.6, 0.1)} (sample size calculations).}

\item{pi2}{A numeric value that represents the assumed probability in the reference group if two treatment
groups are considered, default is \code{0.2}.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. If \code{allocationRatioPlanned = 0} is entered,
the optimal allocation ratio yielding the smallest overall sample size is determined.}
}
\value{
Returns a \code{\link{TrialDesignPlan}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.TrialDesignSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.TrialDesignPlan]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.TrialDesignPlan]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the sample size for testing rates in one or two samples.
}
\details{
At given design the function calculates the stage-wise (non-cumulated) and maximum sample size for testing rates.
In a two treatment groups design, additionally, an allocation ratio = n1/n2 can be specified.
If a null hypothesis value thetaH0 != 0 for testing the difference of two rates
thetaH0 != 1 for testing the risk ratio is specified, the sample size
formula according to Farrington & Manning (Statistics in Medicine, 1990) is used.
Critical bounds and stopping for futility bounds are provided at the effect scale
(rate, rate difference, or rate ratio, respectively) for each sample size calculation separately.
For the two-sample case, the calculation here is performed at fixed pi2 as given as argument
in the function.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Calculate the stage-wise sample sizes, maximum sample sizes, and the optimum 
# allocation ratios for a range of pi1 values when testing 
# H0: pi1 - pi2 = -0.1 within a two-stage O'Brien & Fleming design;
# alpha = 0.05 one-sided, power 1 - beta = 90\%:
getSampleSizeRates(getDesignGroupSequential(kMax = 2, alpha = 0.05,  
    beta = 0.1), groups = 2, thetaH0 = -0.1, pi1 = seq(0.4, 0.55, 0.025), 
    pi2 = 0.4, allocationRatioPlanned = 0)
\dontrun{
# Calculate the stage-wise sample sizes, maximum sample sizes, and the optimum 
# allocation ratios for a range of pi1 values when testing 
# H0: pi1 / pi2 = 0.80 within a three-stage O'Brien & Fleming design;
# alpha = 0.025 one-sided, power 1 - beta = 90\%:
getSampleSizeRates(getDesignGroupSequential(kMax = 3, alpha = 0.025, 
    beta = 0.1), groups = 2, riskRatio = TRUE, thetaH0 = 0.80, 
    pi1 = seq(0.3, 0.5, 0.025), pi2 = 0.3, allocationRatioPlanned = 0)
}

}
\seealso{
Other sample size functions: 
\code{\link{getSampleSizeMeans}()},
\code{\link{getSampleSizeSurvival}()}
}
\concept{sample size functions}
