% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_multiarm_survival.R
\name{getSimulationMultiArmSurvival}
\alias{getSimulationMultiArmSurvival}
\title{Get Simulation Multi-Arm Survival}
\usage{
getSimulationMultiArmSurvival(
  design = NULL,
  ...,
  activeArms = 3L,
  effectMatrix = NULL,
  typeOfShape = c("linear", "sigmoidEmax", "userDefined"),
  omegaMaxVector = seq(1, 2.6, 0.4),
  gED50 = NA_real_,
  slope = 1,
  intersectionTest = c("Dunnett", "Bonferroni", "Simes", "Sidak", "Hierarchical"),
  directionUpper = TRUE,
  adaptations = NA,
  typeOfSelection = c("best", "rBest", "epsilon", "all", "userDefined"),
  effectMeasure = c("effectDifference", "testStatistic"),
  successCriterion = c("all", "atLeastOne"),
  epsilonValue = NA_real_,
  rValue = NA_real_,
  threshold = -Inf,
  plannedEvents = NA_real_,
  allocationRatioPlanned = NA_real_,
  minNumberOfEventsPerStage = NA_real_,
  maxNumberOfEventsPerStage = NA_real_,
  conditionalPower = NA_real_,
  thetaH1 = NA_real_,
  maxNumberOfIterations = 1000L,
  seed = NA_real_,
  calcEventsFunction = NULL,
  selectArmsFunction = NULL,
  showStatistics = TRUE
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower}, 
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{activeArms}{The number of active treatment arms to be compared with control, default is 3.}

\item{effectMatrix}{Matrix of effect sizes with \code{activeArms} columns and number of rows 
reflecting the different situations to consider.}

\item{typeOfShape}{The shape of the dose-response relationship over the treatment groups. 
This can be either \code{"linear"}, \code{"sigmoidEmax"}, or \code{"userDefined"}.
If \code{"sigmoidEmax"} is selected, \code{"gED50"} and \code{"slope"} has to be entered 
to specify the ED50 and the slope of the sigmoid Emax model.
For \code{"linear"} and \code{"sigmoidEmax"}, \code{"muMaxVector"} specifies the range 
of effect sizes for the treatment group with highest response.    
If \code{"userDefined"} is selected, \code{"effectMatrix"} has to be entered.}

\item{omegaMaxVector}{Range of hazard ratios with highest response for \code{"linear"} and \code{"sigmoidEmax"} model, default is \code{seq(1, 2.6, 0.4)}.}

\item{gED50}{If \code{"sigmoidEmax"} is selected, \code{"gED50"} has to be entered 
to specify the ED50 of the sigmoid Emax model.}

\item{slope}{If \code{"sigmoidEmax"} is selected, \code{"slope"} can be entered 
to specify the slope of the sigmoid Emax model, default is 1.}

\item{intersectionTest}{Defines the multiple test for the intersection 
hypotheses in the closed system of hypotheses. 
Five options are available: \code{"Dunnett"}, \code{"Bonferroni"}, \code{"Simes"}, 
\code{"Sidak"}, and \code{"Hierarchical"}, default is \code{"Dunnett"}.}

\item{directionUpper}{Specifies the direction of the alternative, 
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{adaptations}{A vector of length \code{kMax - 1} indicating whether or not an adaptation takes 
place at interim k, default is \code{rep(TRUE, kMax - 1)}.}

\item{typeOfSelection}{The way the treatment arms are selected at interim. 
Five options are available: \code{"best"}, \code{"rbest"}, \code{"epsilon"}, \code{"all"}, and \code{"userDefined"},
default is \code{"best"}.\cr
For \code{"rbest"} (select the rbest best treatment arms), the parameter \code{rValue} has to be specified,
for \code{"epsilon"} (select treatment arm not worse than epsilon compared to the best), the parameter
\code{epsilonValue} has to be specified.
If \code{"userDefined"} is selected, \code{"selectArmsFunction"} has to be specified.}

\item{effectMeasure}{Criterion for treatment arm selection, either based on test statistic 
(\code{"testStatistic"}) or effect difference (\code{"effectDifference"}), 
default is \code{"effectDifference"}.}

\item{successCriterion}{Defines when the study is stopped for efficacy at interim. 
Two options are available: \code{"all"} stops the trial 
if the efficacy criterion is fulfilled for all selected treatment arms, 
\code{"atLeastOne"} stops if at least one of the selected treatment arms is shown to be 
superior to control at interim, default is \code{"all"}.}

\item{epsilonValue}{For \code{"epsilon"} (select treatment arm not worse than 
epsilon compared to the best), the parameter \code{epsilonValue} has to be specified.}

\item{rValue}{For \code{"rbest"} (select the rbest best treatment arms), 
the parameter \code{rValue} has to be specified.}

\item{threshold}{Selection criterion: treatment arm is selected only if \code{effectMeasure} 
exceeds \code{threshold}, default is \code{-Inf}. 
\code{threshold} can also be a vector of length \code{activeArms} referring to 
a separate threshold condition over the treatment arms.}

\item{plannedEvents}{\code{plannedEvents} is a vector of length \code{kMax} (the number of stages of the design) 
   that determines the number of cumulated (overall) events in survival designs when the interim stages are planned.
   For two treatment arms, it is the number of events for both treatment arms. 
For multi-arm designs, \code{plannedEvents} refers to the number of events per selected comparison to control.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups 
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.}

\item{minNumberOfEventsPerStage}{When performing a data driven sample size recalculation, 
the vector \code{minNumberOfEventsPerStage} with length kMax determines the 
minimum number of events per stage (i.e., not cumulated), the first element 
is not taken into account.}

\item{maxNumberOfEventsPerStage}{When performing a data driven sample size recalculation, 
the vector \code{maxNumberOfEventsPerStage} with length kMax determines the maximum number 
of events per stage (i.e., not cumulated), the first element is not taken into account.}

\item{conditionalPower}{If \code{conditionalPower} together with \code{minNumberOfSubjectsPerStage} and 
\code{maxNumberOfSubjectsPerStage} (or \code{minNumberOfEventsPerStage} and \code{maxNumberOfEventsPerStage}
for survival designs) is specified, a sample size recalculation based on the specified conditional power is performed.
It is defined as the power for the subsequent stage given the current data. By default, 
the conditional power is calculated under the observed effect size. Optionally, you can also specify \code{thetaH1} and
\code{stDevH1} (for simulating means), \code{pi1H1} and \code{pi2H1} (for simulating rates), or \code{thetaH1} (for simulating
hazard ratios) as parameters under which it is calculated and the sample size recalculation is performed.}

\item{thetaH1}{If specified, the value of the alternative under which 
the conditional power or sample size recalculation calculation is performed.}

\item{maxNumberOfIterations}{The number of simulation iterations, default is 1000.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{calcEventsFunction}{Optionally, a function can be entered that defines the way of performing the sample size
recalculation. By default, sample size recalculation is performed with conditional power with specified
\code{minNumberOfEventsPerStage} and \code{maxNumberOfEventsPerStage} (see details and examples).}

\item{selectArmsFunction}{Optionally, a function can be entered that defines the way of how treatment arms
are selected. This function has to depend on \code{effectVector} with length \code{activeArms} (see examples).}

\item{showStatistics}{If \code{TRUE}, summary statistics of the simulated data
are displayed for the \code{print} command, otherwise the output is suppressed, default
is \code{FALSE}.}
}
\value{
Returns a \code{\link{SimulationResults}} object.
The following generics (R generic functions) are available for this object:
\itemize{
  \item \code{\link[=names.FieldSet]{names}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print}} to print the object,
  \item \code{\link[=summary.ParameterSet]{summary}} to display a summary of the object,
  \item \code{\link[=plot.SimulationResults]{plot}} to plot the object,
  \item \code{\link[=as.data.frame.ParameterSet]{as.data.frame}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the simulated power, stopping probabilities, conditional power, and expected sample size 
for testing survival in a multi-arm treatment groups testing situation. In contrast to \code{getSimulationSurvival()} (where survival times are simulated), normally
distributed logrank test statistics are simulated.
}
\details{
At given design the function simulates the power, stopping probabilities, selection probabilities, and expected 
sample size at given number of subjects, parameter configuration, and treatment arm selection rule in the multi-arm situation. 
An allocation ratio can be specified referring to the ratio of number of subjects in the active treatment groups as compared to the control group.
 
The definition of \code{thetaH1} makes only sense if \code{kMax} > 1
and if \code{conditionalPower}, \code{minNumberOfEventsPerStage}, and 
\code{maxNumberOfEventsPerStage} (or \code{calcEventsFunction}) are defined.

\code{calcEventsFunction}\cr 
This function returns the number of events at given conditional power and conditional critical value for specified 
testing situation. The function might depend on the variables 
\code{stage}, 
\code{selectedArms}, 
\code{plannedEvents}, 
\code{directionUpper}, 
\code{allocationRatioPlanned}, 
\code{minNumberOfEventsPerStage}, 
\code{maxNumberOfEventsPerStage}, 
\code{conditionalPower}, 
\code{conditionalCriticalValue}, and 
\code{overallEffects}. 
The function has to contain the three-dots argument '...' (see examples).
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\donttest{
# Assess different selection rules for a two-stage survival design with 
# O'Brien & Fleming alpha spending boundaries and (non-binding) stopping 
# for futility if the test statistic is negative. 
# Number of events at the second stage is adjusted based on conditional 
# power 80\% and specified minimum and maximum number of Events.
maxNumberOfIterations <- 50
design <- getDesignInverseNormal(typeOfDesign = "asOF", futilityBounds = 0)

y1 <- getSimulationMultiArmSurvival(design = design, activeArms = 4, 
    intersectionTest = "Simes", typeOfShape = "sigmoidEmax", 
    omegaMaxVector = seq(1, 2, 0.5), gED50 = 2, slope = 4, 
    typeOfSelection = "best", conditionalPower = 0.8, 
    minNumberOfEventsPerStage = c(NA_real_, 30), 
    maxNumberOfEventsPerStage = c(NA_real_, 90),
    maxNumberOfIterations = maxNumberOfIterations, 
    plannedEvents = c(30, 60))

y2 <- getSimulationMultiArmSurvival(design = design, activeArms = 4, 
    intersectionTest = "Simes", typeOfShape = "sigmoidEmax", 
    omegaMaxVector = seq(1,2,0.5), gED50 = 2, slope = 4,
    typeOfSelection = "epsilon", epsilonValue = 0.2, 
    effectMeasure = "effectDifference",
    conditionalPower = 0.8, minNumberOfEventsPerStage = c(NA_real_, 30), 
    maxNumberOfEventsPerStage = c(NA_real_, 90),
    maxNumberOfIterations = maxNumberOfIterations, plannedEvents = c(30, 60))

y1$effectMatrix

y1$rejectAtLeastOne
y2$rejectAtLeastOne

y1$selectedArms
y2$selectedArms
}

}
