% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getSampleSizeMeans}
\alias{getSampleSizeMeans}
\title{Get Sample Size Means}
\usage{
getSampleSizeMeans(design, ..., normalApproximation = FALSE,
  meanRatio = FALSE, thetaH0 = 0, alternative = seq(0.2, 1, 0.2),
  stDev = 1, groups = 2, allocationRatioPlanned = 1)
}
\arguments{
\item{design}{The trial design.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{normalApproximation}{If \code{normalApproximation = TRUE} is specified, the variance is 
assumed to be known, default is FALSE.}

\item{meanRatio}{If \code{meanRatio = TRUE} is specified, the sample size for 
one-sided testing of H0: mu1/mu2 = thetaH0 is calculated, default is FALSE.}

\item{thetaH0}{The null hypothesis value. For one-sided testing, a value != 0 
(or a value != 1 for testing the mean ratio) can be specified, default is 0.}

\item{alternative}{The alternative hypothesis value. This can be a vector of assumed 
alternatives, default is seq(0.1, 2, 0.2).}

\item{stDev}{The standard deviation, default is 1. If \code{meanRatio = TRUE} 
is specified, stDev defines the coefficient of variation sigma/mu2.}

\item{groups}{The number of treatment groups (1 or 2), default is 2.}

\item{allocationRatioPlanned}{The planned allocation ratio for a two treatment groups 
design, default is 1. If \code{allocationRatioPlanned = 0} is entered, 
   the optimal allocation ratio yielding the smallest overall sample size is determined.}
}
\value{
Returns a \code{TrialDesignPlanMeans} object.
}
\description{
Returns the sample size for testing means in one and two samples.
}
\details{
At given design the function calculates the sample size for testing means.
In a two treatment groups design, additionally, an allocation ratio = n1Fixed/n2Fixed can be specified. 
A null hypothesis value thetaH0 != 0 for testing the difference of two means or  
thetaH0 != 1 for testing the ratio of two means can be specified.
}
\examples{

# Calculate sample sizes n1Fixed, n2Fixed, and 
# nFixed for a range of alternative values:
getSampleSizeMeans(getDesignGroupSequential(alpha = 0.025, sided = 1), 
    groups = 2, alternative = seq(0.1, 2, 0.2), 
    normalApproximation = FALSE, allocationRatioPlanned = 2)

}
