\name{sandbox}
\alias{sandbox}
\title{Run actions in a sandbox}
\usage{
  sandbox(active = FALSE,
    sandbox.dir = file.path(tempdir(), "roxyPackge", "sandbox"),
    pck.source.dir = TRUE, R.libs = TRUE, repo.root = TRUE,
    archive = repo.root)
}
\arguments{
  \item{active}{Logical, whether sandboxing should be
  active or not}

  \item{sandbox.dir}{Character string, full path to the
  sandbox root directory to use.  Will be created if
  neccessary (at first use, not when setting this here!).}

  \item{pck.source.dir}{Logical, whether to sandbox the
  package sources. If \code{TRUE} the full package sources
  will be copied to \code{file.path(sandbox.dir, "src")}
  (at first use, not when setting this here!).}

  \item{R.libs}{Logical, whether to sandbox the R library
  directory, that is, the directory to install the package
  to. Since this needs also to provide all package
  dependencies, those packages will be copied to
  \code{file.path(sandbox.dir, "R")} (at first use, not
  when setting this here!).}

  \item{repo.root}{Logical, whether to sandbox the
  repository. This repository will be set up in
  \code{file.path(sandbox.dir, "repo")} (at first use, not
  when setting this here!).}

  \item{archive}{Logical, whether to sandbox the repository
  archive. The archive will be set up in
  \code{file.path(sandbox.dir, "repo_archive")} (at first
  use, not when setting this here!).}
}
\value{
  Settings are stored in an internal environment, so there
  is no actual return value.
}
\description{
  If you want to test the effects of
  \code{\link[roxyPackage:roxy.package]{roxy.package}},
  \code{\link[roxyPackage:archive.packages]{archive.packages}}
  or \code{\link[roxyPackage:debianize]{debianize}}, you
  can activate a sandbox with this function.
}
\details{
  Sandboxing means that you are able to specify which
  groups of actions should only be run in a separate
  environment. This can be useful if you don't want to make
  changes to your actual package code, but inspect the
  result first.

  With this function, you can turn sandboxing on and off.
  This setting has effects only in the currently running R
  session. By default, sandboxing is off.
}
\examples{
\dontrun{
# turn sandboxing on
sandbox(active=TRUE)
}
}
\seealso{
  \code{\link[roxyPackage:sandbox.status]{sandbox.status}}
  to see the current settings.
}

