% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnrs.R
\name{tnrs_infer_context}
\alias{tnrs_infer_context}
\title{Infer the taxonomic context from a list of names}
\usage{
tnrs_infer_context(names = NULL, ...)
}
\arguments{
\item{names}{Vector of taxon names.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
A list including the context name, the context ott id and
    possibly the names in the query that have an ambiguous
    taxonomic meaning in the query.
}
\description{
Return a taxonomic context given a list of taxonomic names
}
\details{
Find the least inclusive taxonomic context that includes all the
unambiguous names in the input set. Unambiguous names are names
with exact matches to non-homonym taxa. Ambiguous names (those
without exact matches to non-homonym taxa) are indicated in
results.
}
\examples{
\dontrun{
res <- tnrs_infer_context(names=c("Stellula calliope", "Struthio camelus"))
}
}

