% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine.R, R/examineBy.R
\name{examine}
\alias{examine}
\alias{print.examine}
\alias{pander.examine}
\alias{examineBy}
\alias{print.examineBy}
\alias{pander.examineBy}
\title{Examine one or more variables}
\usage{
examine(
  ...,
  stem = TRUE,
  plots = TRUE,
  extremeValues = 5,
  qqCI = TRUE,
  conf.level = 0.95
)

\method{print}{examine}(x, ...)

\method{pander}{examine}(
  x,
  headerPrefix = "",
  headerStyle = "**",
  secondaryHeaderPrefix = "",
  secondaryHeaderStyle = "*",
  ...
)

examineBy(
  ...,
  by = NULL,
  stem = TRUE,
  plots = TRUE,
  extremeValues = 5,
  qqCI = TRUE,
  conf.level = 0.95
)

\method{print}{examineBy}(x, ...)

\method{pander}{examineBy}(
  x,
  headerPrefix = "",
  headerStyle = "**",
  secondaryHeaderPrefix = "",
  secondaryHeaderStyle = "*",
  tertairyHeaderPrefix = "--> ",
  tertairyHeaderStyle = "",
  separator = paste0("\\n\\n", repStr("-", 10), "\\n\\n"),
  ...
)
}
\arguments{
\item{\dots}{The first argument is a list of variables to provide
descriptives for. Because these are the first arguments, the other arguments
must be named explicitly so R does not confuse them for something that
should be part of the dots.}

\item{stem}{Whether to display a stem and leaf plot.}

\item{plots}{Whether to display the plots generated by the
\code{\link[ufs:normalityAssessment]{ufs::dataShape()}} function.}

\item{extremeValues}{How many extreme values to show at either end (the
highest and lowest values). When set to FALSE (or 0), no extreme values are
shown.}

\item{qqCI}{Whether to display confidence intervals in the QQ-plot.}

\item{conf.level}{The level of confidence of the confidence interval.}

\item{x}{The object to print or pander.}

\item{headerPrefix, secondaryHeaderPrefix, tertairyHeaderPrefix}{Prefixes
for the primary, secondary header, and tertairy headers}

\item{headerStyle, secondaryHeaderStyle, tertairyHeaderStyle}{Characteers to
surround the primary, secondary, and tertairy headers with}

\item{by}{A variable by which to split the dataset before calling
\code{\link{examine}}. This can be used to show the descriptives separate by
levels of a factor.}

\item{separator}{Separator for the result blocks.}
}
\value{
A list that is displayed when printed.
}
\description{
These functions are one of many R functions enabling users to assess
variable descriptives. They have been developed to mimic SPSS' 'EXAMINE'
syntax command ('Explore' in the menu) as closely as possible to ease the
transition for new R users and facilitate teaching courses where both
programs are taught alongside each other.
}
\details{
This function basically just calls the \code{\link{descr}} function,
optionally supplemented with calls to \code{\link{stem}},
\code{\link[ufs:normalityAssessment]{ufs::dataShape()}}.
}
\examples{

### Look at the miles per gallon descriptives:
rosetta::examine(mtcars$mpg, stem=FALSE, plots=FALSE);

### Separate for the different number of cylinders:
rosetta::examineBy(
  mtcars$mpg, by=mtcars$cyl,
  stem=FALSE, plots=FALSE,
  extremeValues=FALSE
);


}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
