% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_climate_projections.R
\name{get_climate_projections}
\alias{get_climate_projections}
\title{Download point-level climate projections using open-meteo API}
\usage{
get_climate_projections(
  latitude,
  longitude,
  site_id = NULL,
  start_date,
  end_date,
  model = "EC_Earth3P_HR",
  variables = c("temperature_2m_mean")
)
}
\arguments{
\item{latitude}{latitude degree north}

\item{longitude}{longitude degree east}

\item{site_id}{name of site location (optional, default = NULL)}

\item{start_date}{Number of days in the future for forecast (starts at current day)}

\item{end_date}{Number of days in the past to include in the data}

\item{model}{id of forest model https://open-meteo.com/en/docs/climate-api}

\item{variables}{vector of name of variable(s) https://open-meteo.com/en/docs/climate-api}
}
\value{
data frame with the results from the call to the open-meteo API.  The data frame is in a long format and has the following columns: "datetime", "reference_datetime", "site_id", "model_id", "ensemble", "variable", "prediction","unit".
}
\description{
Download point-level climate projections using open-meteo API
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

get_climate_projections(
latitude = 37.30,
longitude = -79.83,
start_date = Sys.Date(),
end_date = Sys.Date() + lubridate::years(1),
model = "EC_Earth3P_HR",
variables = c("temperature_2m_mean"))
\dontshow{\}) # examplesIf}
}
