% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_to_hourly.R
\name{daily_to_hourly}
\alias{daily_to_hourly}
\title{Convert daily climate projections to hourly time-step}
\usage{
daily_to_hourly(df, latitude, longitude)
}
\arguments{
\item{df}{data frame output by \code{get_climate_projections()} that has daily values for the variable}

\item{latitude}{latitude degree north}

\item{longitude}{longitude degree east}
}
\value{
data frame with an hourly time step
}
\description{
Convert daily climate projections to hourly time-step
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_climate_projections(
latitude = 37.30,
longitude = -79.83,
start_date = Sys.Date(),
end_date = Sys.Date() + lubridate::years(1),
model = "EC_Earth3P_HR",
variables = glm_variables(product = "climate_projection", time_step = "daily")) |>
daily_to_hourly(latitude = 37.30, longitude = -79.83)
\dontshow{\}) # examplesIf}
}
