% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurements.R
\name{aq_measurements}
\alias{aq_measurements}
\title{Function for getting measurements table from the openAQ API}
\usage{
aq_measurements(country = NULL, city = NULL, location = NULL,
  parameter = NULL, has_geo = NULL, date_from = NULL, date_to = NULL,
  limit = 100, value_from = NULL, value_to = NULL, page = 1)
}
\arguments{
\item{country}{Limit results by a certain country -- a two-letters code see countries() for finding code based on name.}

\item{city}{Limit results by a certain city.}

\item{location}{Limit results by a certain location.}

\item{parameter}{Limit to only a certain parameter (valid values are 'pm25', 'pm10', 'so2', 'no2', 'o3', 'co' and 'bc').
If no parameter is given, all parameters are retrieved.}

\item{has_geo}{Filter out items that have or do not have geographic information.}

\item{date_from}{Show results after a certain date. (character year-month-day, ex. '2015-12-20')}

\item{date_to}{Show results before a certain date. (character year-month-day, ex. '2015-12-20')}

\item{limit}{Change the number of results returned, max is 1000.}

\item{value_from}{Show results above value threshold, useful in combination with \code{parameter}.}

\item{value_to}{Show results below value threshold, useful in combination with \code{parameter}.}

\item{page}{The page of the results to query. This can be useful if e.g. there are 2000 measurements, then first use page=1 and page=2 with limit=100 to get all measurements for your query.}
}
\value{
a list of 3 data.frames, a results data.frame (dplyr "tbl_df") with 12 columns:
\itemize{
 \item the name of the location ("location"),
 \item the parameter ("parameter")
 \item the value of the measurement ("value")
 \item the unit of the measure ("unit")
 \item the code of country the location is in ("country"),
 \item the city it is in ("city"),
 \item and finally an URL encoded version of the city name ("cityURL")
 \item and of the location name ("locationURL"),
 \item the UTC POSIXct time ("dateUTC"),
 \item the local POSIXct time ("dateLocal"),
 \item its longitude ("longitude") and latitude if available ("latitude").
}
meta data.frame (dplyr "tbl_df") with 1 line and 5 columns:
\itemize{
\item the API name ("name"),
\item the license of the data ("license"),
\item the website url ("website"),
\item the queried page ("page"),
\item the limit on the number of results ("limit"),
\item the number of results found on the platform for the query ("found")
}
last, a timestamp data.frame (dplyr "tbl_df") with the query time and the last time at which the data was modified on the platform.
}
\description{
Function for getting measurements table from the openAQ API
}
\details{
For queries involving a city or location argument,
the URL-encoded name of the city/location (as in cityURL/locationURL),
not its name, should be used.
 You can query any nested combination of country/location/city (level 1, 2 and 3),
 with only one value for each argument.
  If you write inconsistent combination such as city="Paris" and country="IN", an error message will be returned.
  If you write city="Delhi", you do not need to write the code of the country, unless
  one day there is a city with the same name in another country.
}
\examples{
\dontrun{
aq_measurements(country='IN', limit=9, city='Chennai')
aq_measurements(country='US', has_geo=TRUE)
}
}

