% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_ggbiv.R
\name{plot_bivariate}
\alias{plot_bivariate}
\title{Bivariate Plot}
\usage{
plot_bivariate(tomic_table, x_var, y_var, color_var = NULL)
}
\arguments{
\item{tomic_table}{A table taken from a tidy (i.e., augmented measurements)
or triple omic dataset}

\item{x_var}{x-axis variable}

\item{y_var}{y-axis variable}

\item{color_var}{coloring variable (NULL to suppress coloring)}
}
\value{
a ggplot2 grob
}
\description{
Create a scatter or boxplot from a tomic dataset.
}
\examples{
library(dplyr)

brauer_augmented <- brauer_2008_tidy \%>\%
  add_pca_loadings(npcs = 5) \%>\%
  tomic_to("triple_omic")

tomic_table <- brauer_augmented$samples
plot_bivariate(tomic_table, "PC1", "PC2", "nutrient")
plot_bivariate(tomic_table, "PC1", "PC2", NULL)
plot_bivariate(tomic_table, "nutrient", "PC2", "nutrient")
}
