% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{execute}
\alias{execute}
\title{Execute SQL statement in database.
Combination of functions execute and clearResult.
If required, database is automatically connected and disconnected.}
\usage{
execute(db, statement, ...)
}
\arguments{
\item{db}{rocker object}

\item{statement}{SQL statement (\code{UPDATE, DELETE, INSERT INTO, ...})}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}}
}
\value{
Number of affected rows
}
\description{
Execute SQL statement in database.
Combination of functions execute and clearResult.
If required, database is automatically connected and disconnected.
}
\examples{
db <- rocker::newDB()
rocker::setupSQLite(db)
rocker::connect(db)
rocker::writeTable(db, "mtcars", mtcars)
rocker::execute(db, "DELETE FROM mtcars WHERE gear = 3;")
rocker::disconnect(db)
rocker::unloadDriver(db)
}
