% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmle}
\alias{mmle}
\title{Maximum Likelihood Estimation for Matrix Normal Distribution}
\usage{
mmle(X, max_iter = 100L, lambda = 0, silent = FALSE)
}
\arguments{
\item{X}{a 3d array of dimension \eqn{(p,q,n)}, containing \eqn{n} matrix-variate samples of \eqn{p} rows and \eqn{q} columns in each slice.}

\item{max_iter}{upper limit of iterations.}

\item{lambda}{is a smoothing parameter for the rowwise and columnwise covariance matrices.}

\item{silent}{Logical. If FALSE (default), warnings and errors are printed.}
}
\value{
A list containing the following:
\item{\code{mu}}{Estimated \eqn{p \times q} mean matrix.}
\item{\code{cov_row}}{Estimated \eqn{p} times \eqn{p} rowwise covariance matrix.}
\item{\code{cov_col}}{Estimated \eqn{q} times \eqn{q} columnwise covariance matrix.}
\item{\code{cov_row_inv}}{Inverse of \code{cov_row}.}
\item{\code{cov_col_inv}}{Inverse of \code{cov_col}.}
\item{\code{norm}}{Forbenius norm of squared differences between covariance matrices in the final iteration.}
\item{\code{iterations}}{Number of iterations of the mmle procedure.}
}
\description{
\code{mmle} computes the Maximum Likelihood Estimators (MLEs) for the matrix normal distribution
using the iterative flip-flop algorithm \insertCite{Dutilleul1999}{robustmatrix}.
}
\examples{
n = 1000; p = 2; q = 3
mu = matrix(rep(0, p*q), nrow = p, ncol = q)
cov_row = matrix(c(1,0.5,0.5,1), nrow = p, ncol = p)
cov_col = matrix(c(3,2,1,2,3,2,1,2,3), nrow = q, ncol = q)
X <- rmatnorm(n = 1000, mu, cov_row, cov_col)
par_mmle <- mmle(X)
}
\references{
\insertAllCited{}
}
\seealso{
For robust parameter estimation use \code{\link{mmcd}}.
}
