% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{summarize}
\alias{summarize}
\title{Differential Expression and Figure Generation}
\usage{
summarize(environment, perplexity = seq(10, 30, 10), max_iter = 10000,
  rerun = F, order = NA, contrast = "all", min.fold = 1.5,
  quantile = 0.95, local = F, mem = "4GB", time = "0:15:00")
}
\arguments{
\item{environment}{\code{environment} object}

\item{perplexity}{perplexity parameters for tSNE analyses}

\item{max_iter}{maximum iterations for tSNE}

\item{rerun}{whether to rerun}

\item{order}{order in which to plot the clusters}

\item{contrast}{either 'all' indicating differential expression between one cluster against all others or 'datasets' indicating differential expression analysis comparing one cluster to all other within each dataset separately ('datasets' should be used in pooled analysis for optimal results)}

\item{min.fold}{minimum fold change for filtering final differentially expressed gene lists}

\item{quantile}{q-value cutoff for differential expression analysis}

\item{local}{Whether to run tSNE locally on SLURM}

\item{mem}{Memory for each job; default 4 GB}

\item{time}{Time for each job; default 15 minutes}
}
\description{
Summarize the clustering results by conducting differential expression analysis and plotting figures.
}
\examples{
\donttest{
# after running cluster.analysis()
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
summarize(LCMV1)
}
}
