% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCA.R
\name{PCA}
\alias{PCA}
\title{Parallelized PCA Analysis}
\usage{
PCA(environment, regress = NA, groups = NA, nShuffleRuns = 10,
  threshold = 0.1, maxPCs = 100, label = NA, mem = "2GB",
  time = "0:10:00", rerun = F,
  clear.previously.calculated.clustering = T, local = F)
}
\arguments{
\item{environment}{\code{environment} object}

\item{regress}{gene signature activation scores to regress}

\item{groups}{experimental design annotation to guide dataset-specific regression}

\item{nShuffleRuns}{number of shuffled analyses}

\item{threshold}{FDR threshold}

\item{maxPCs}{maximum number of possible PCs}

\item{label}{optional analyses label folder}

\item{mem}{HPC memory}

\item{time}{HPC time}

\item{rerun}{whether to rerun the analysis rather than load from cache}

\item{clear.previously.calculated.clustering}{whether to clear previous clustering analysis}

\item{local}{whether to run jobs locally on slurm instead of submitting the job}
}
\value{
\code{environment} parameter containing PC coordinates
}
\description{
Run PCA analysis with a simulation analysis of shuffled data to determine the appropriate number of PCs.
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
}
}
